@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the status and behavior of a service.
 * @property startupType The behavior of the service when the Arc-enabled machine starts up.
 * @property status The current status of the service.
 */
public data class ServiceStatusResponse(
    public val startupType: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.ServiceStatusResponse):
            ServiceStatusResponse = ServiceStatusResponse(
            startupType = javaType.startupType().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
