@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.Suppress

/**
 * Reports the state and behavior of dependent services.
 * @property extensionService The state of the extension service on the Arc-enabled machine.
 * @property guestConfigurationService The state of the guest configuration service on the Arc-enabled machine.
 */
public data class ServiceStatusesResponse(
    public val extensionService: ServiceStatusResponse? = null,
    public val guestConfigurationService: ServiceStatusResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.ServiceStatusesResponse):
            ServiceStatusesResponse = ServiceStatusesResponse(
            extensionService = javaType.extensionService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.ServiceStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            guestConfigurationService = javaType.guestConfigurationService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.ServiceStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
