@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The endpoint access for the target resource.
 * @property accessKey Access key for hybrid connection.
 * @property expiresOn The expiration of access key in unix time.
 * @property hybridConnectionName Azure Relay hybrid connection name for the resource.
 * @property namespaceName The namespace name.
 * @property namespaceNameSuffix The suffix domain name of relay namespace.
 * @property serviceConfigurationToken The token to access the enabled service.
 */
public data class ListEndpointCredentialsResult(
    public val accessKey: String,
    public val expiresOn: Double? = null,
    public val hybridConnectionName: String,
    public val namespaceName: String,
    public val namespaceNameSuffix: String,
    public val serviceConfigurationToken: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridconnectivity.outputs.ListEndpointCredentialsResult):
            ListEndpointCredentialsResult = ListEndpointCredentialsResult(
            accessKey = javaType.accessKey(),
            expiresOn = javaType.expiresOn().map({ args0 -> args0 }).orElse(null),
            hybridConnectionName = javaType.hybridConnectionName(),
            namespaceName = javaType.namespaceName(),
            namespaceNameSuffix = javaType.namespaceNameSuffix(),
            serviceConfigurationToken = javaType.serviceConfigurationToken().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
