@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
 */
public enum class LicenseType(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.LicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.LicenseType> {
    Windows_Server(com.pulumi.azurenative.hybridcontainerservice.enums.LicenseType.Windows_Server),
    None(com.pulumi.azurenative.hybridcontainerservice.enums.LicenseType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.LicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.LicenseType):
            LicenseType = LicenseType.values().first { it.javaValue == javaType }
    }
}
