@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
 */
public enum class Mode(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.Mode,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.Mode> {
    System(com.pulumi.azurenative.hybridcontainerservice.enums.Mode.System),
    LB(com.pulumi.azurenative.hybridcontainerservice.enums.Mode.LB),
    User(com.pulumi.azurenative.hybridcontainerservice.enums.Mode.User),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.Mode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.Mode): Mode =
            Mode.values().first { it.javaValue == javaType }
    }
}
