@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * CloudProviderProfile - The underlying cloud infra provider properties.
 * @property infraNetworkProfile InfraNetworkProfile - List of infra network profiles for the provisioned cluster
 * @property infraStorageProfile InfraStorageProfile - List of infra storage profiles for the provisioned cluster
 */
public data class CloudProviderProfileArgs(
    public val infraNetworkProfile: Output<CloudProviderProfileInfraNetworkProfileArgs>? = null,
    public val infraStorageProfile: Output<CloudProviderProfileInfraStorageProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileArgs.builder()
            .infraNetworkProfile(
                infraNetworkProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .infraStorageProfile(
                infraStorageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudProviderProfileArgs].
 */
@PulumiTagMarker
public class CloudProviderProfileArgsBuilder internal constructor() {
    private var infraNetworkProfile: Output<CloudProviderProfileInfraNetworkProfileArgs>? = null

    private var infraStorageProfile: Output<CloudProviderProfileInfraStorageProfileArgs>? = null

    /**
     * @param value InfraNetworkProfile - List of infra network profiles for the provisioned cluster
     */
    @JvmName("ruoopniyjbrgembq")
    public suspend
    fun infraNetworkProfile(`value`: Output<CloudProviderProfileInfraNetworkProfileArgs>) {
        this.infraNetworkProfile = value
    }

    /**
     * @param value InfraStorageProfile - List of infra storage profiles for the provisioned cluster
     */
    @JvmName("teyigilmtxmdqrld")
    public suspend
    fun infraStorageProfile(`value`: Output<CloudProviderProfileInfraStorageProfileArgs>) {
        this.infraStorageProfile = value
    }

    /**
     * @param value InfraNetworkProfile - List of infra network profiles for the provisioned cluster
     */
    @JvmName("pjrqkcnhuwqkabig")
    public suspend fun infraNetworkProfile(`value`: CloudProviderProfileInfraNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infraNetworkProfile = mapped
    }

    /**
     * @param argument InfraNetworkProfile - List of infra network profiles for the provisioned cluster
     */
    @JvmName("rauspiwpfitwypwv")
    public suspend
    fun infraNetworkProfile(argument: suspend CloudProviderProfileInfraNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudProviderProfileInfraNetworkProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.infraNetworkProfile = mapped
    }

    /**
     * @param value InfraStorageProfile - List of infra storage profiles for the provisioned cluster
     */
    @JvmName("waihugkfcaikxrnm")
    public suspend fun infraStorageProfile(`value`: CloudProviderProfileInfraStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infraStorageProfile = mapped
    }

    /**
     * @param argument InfraStorageProfile - List of infra storage profiles for the provisioned cluster
     */
    @JvmName("pyrrcflhmbddlkva")
    public suspend
    fun infraStorageProfile(argument: suspend CloudProviderProfileInfraStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudProviderProfileInfraStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.infraStorageProfile = mapped
    }

    internal fun build(): CloudProviderProfileArgs = CloudProviderProfileArgs(
        infraNetworkProfile = infraNetworkProfile,
        infraStorageProfile = infraStorageProfile,
    )
}
