@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.GetHybridIdentityMetadatumPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hybridIdentityMetadataResourceName Parameter for the name of the hybrid identity metadata resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Parameter for the name of the provisioned cluster
 */
public data class GetHybridIdentityMetadatumPlainArgs(
    public val hybridIdentityMetadataResourceName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.GetHybridIdentityMetadatumPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.GetHybridIdentityMetadatumPlainArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.GetHybridIdentityMetadatumPlainArgs.builder()
            .hybridIdentityMetadataResourceName(hybridIdentityMetadataResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridIdentityMetadatumPlainArgs].
 */
@PulumiTagMarker
public class GetHybridIdentityMetadatumPlainArgsBuilder internal constructor() {
    private var hybridIdentityMetadataResourceName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Parameter for the name of the hybrid identity metadata resource.
     */
    @JvmName("niikaxasxychgbbb")
    public suspend fun hybridIdentityMetadataResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hybridIdentityMetadataResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tbrwkstiioljfend")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("edljwljtnfcweywn")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetHybridIdentityMetadatumPlainArgs = GetHybridIdentityMetadatumPlainArgs(
        hybridIdentityMetadataResourceName = hybridIdentityMetadataResourceName ?: throw
            PulumiNullFieldException("hybridIdentityMetadataResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
