@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * LinuxProfile - Profile for Linux VMs in the container service cluster.
 * @property adminUsername AdminUsername - The administrator username to use for Linux VMs.
 * @property ssh SSH - SSH configuration for Linux-based VMs running on Azure.
 */
public data class LinuxProfilePropertiesArgs(
    public val adminUsername: Output<String>? = null,
    public val ssh: Output<LinuxProfilePropertiesSshArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesArgs.builder()
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LinuxProfilePropertiesArgs].
 */
@PulumiTagMarker
public class LinuxProfilePropertiesArgsBuilder internal constructor() {
    private var adminUsername: Output<String>? = null

    private var ssh: Output<LinuxProfilePropertiesSshArgs>? = null

    /**
     * @param value AdminUsername - The administrator username to use for Linux VMs.
     */
    @JvmName("rnlrvehtnspfjrkg")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value SSH - SSH configuration for Linux-based VMs running on Azure.
     */
    @JvmName("hcxmgnakgdqjwcgf")
    public suspend fun ssh(`value`: Output<LinuxProfilePropertiesSshArgs>) {
        this.ssh = value
    }

    /**
     * @param value AdminUsername - The administrator username to use for Linux VMs.
     */
    @JvmName("gtaugxbbxmxrjxtg")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value SSH - SSH configuration for Linux-based VMs running on Azure.
     */
    @JvmName("guadodjwlnaclyoa")
    public suspend fun ssh(`value`: LinuxProfilePropertiesSshArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument SSH - SSH configuration for Linux-based VMs running on Azure.
     */
    @JvmName("hakvipxxbdhqxrvd")
    public suspend fun ssh(argument: suspend LinuxProfilePropertiesSshArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxProfilePropertiesSshArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    internal fun build(): LinuxProfilePropertiesArgs = LinuxProfilePropertiesArgs(
        adminUsername = adminUsername,
        ssh = ssh,
    )
}
