@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesPublicKeysArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyData KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
 */
public data class LinuxProfilePropertiesPublicKeysArgs(
    public val keyData: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesPublicKeysArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesPublicKeysArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesPublicKeysArgs.builder()
            .keyData(keyData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinuxProfilePropertiesPublicKeysArgs].
 */
@PulumiTagMarker
public class LinuxProfilePropertiesPublicKeysArgsBuilder internal constructor() {
    private var keyData: Output<String>? = null

    /**
     * @param value KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
     */
    @JvmName("qlpjnoehhqquhyjr")
    public suspend fun keyData(`value`: Output<String>) {
        this.keyData = value
    }

    /**
     * @param value KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
     */
    @JvmName("wwnhxatyoqacqrqg")
    public suspend fun keyData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyData = mapped
    }

    internal fun build(): LinuxProfilePropertiesPublicKeysArgs = LinuxProfilePropertiesPublicKeysArgs(
        keyData = keyData,
    )
}
