@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.NamedAgentPoolProfileArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.Mode
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.OsType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Agent pool profile along with a name parameter
 * @property availabilityZones AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
 * @property cloudProviderProfile The underlying cloud infra provider properties.
 * @property count Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
 * @property maxCount The maximum number of nodes for auto-scaling
 * @property maxPods The maximum number of pods that can run on a node.
 * @property minCount The minimum number of nodes for auto-scaling
 * @property mode Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
 * @property name Unique name of the agent pool profile in the context of the subscription and resource group.
 * @property nodeImageVersion The version of node image
 * @property nodeLabels NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
 * @property nodeTaints NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
 * @property osType OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
 * @property vmSize VmSize - The size of the agent pool VMs.
 */
public data class NamedAgentPoolProfileArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val cloudProviderProfile: Output<CloudProviderProfileArgs>? = null,
    public val count: Output<Int>? = null,
    public val maxCount: Output<Int>? = null,
    public val maxPods: Output<Int>? = null,
    public val minCount: Output<Int>? = null,
    public val mode: Output<Either<String, Mode>>? = null,
    public val name: Output<String>? = null,
    public val nodeImageVersion: Output<String>? = null,
    public val nodeLabels: Output<Map<String, String>>? = null,
    public val nodeTaints: Output<List<String>>? = null,
    public val osType: Output<Either<String, OsType>>? = null,
    public val vmSize: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.NamedAgentPoolProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.NamedAgentPoolProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.NamedAgentPoolProfileArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cloudProviderProfile(
                cloudProviderProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .count(count?.applyValue({ args0 -> args0 }))
            .maxCount(maxCount?.applyValue({ args0 -> args0 }))
            .maxPods(maxPods?.applyValue({ args0 -> args0 }))
            .minCount(minCount?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .nodeImageVersion(nodeImageVersion?.applyValue({ args0 -> args0 }))
            .nodeLabels(
                nodeLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .nodeTaints(nodeTaints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamedAgentPoolProfileArgs].
 */
@PulumiTagMarker
public class NamedAgentPoolProfileArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var cloudProviderProfile: Output<CloudProviderProfileArgs>? = null

    private var count: Output<Int>? = null

    private var maxCount: Output<Int>? = null

    private var maxPods: Output<Int>? = null

    private var minCount: Output<Int>? = null

    private var mode: Output<Either<String, Mode>>? = null

    private var name: Output<String>? = null

    private var nodeImageVersion: Output<String>? = null

    private var nodeLabels: Output<Map<String, String>>? = null

    private var nodeTaints: Output<List<String>>? = null

    private var osType: Output<Either<String, OsType>>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("ylexfexfkiufjsig")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("qrwlygwbdifvkips")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("lpqfgaorlemqdpqa")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("xkhixrdsdcfgsget")
    public suspend fun cloudProviderProfile(`value`: Output<CloudProviderProfileArgs>) {
        this.cloudProviderProfile = value
    }

    /**
     * @param value Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JvmName("kjdbbswpdnlkvqxg")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The maximum number of nodes for auto-scaling
     */
    @JvmName("mqpgmtylekyegmju")
    public suspend fun maxCount(`value`: Output<Int>) {
        this.maxCount = value
    }

    /**
     * @param value The maximum number of pods that can run on a node.
     */
    @JvmName("ujgkaxttwmchdkfk")
    public suspend fun maxPods(`value`: Output<Int>) {
        this.maxPods = value
    }

    /**
     * @param value The minimum number of nodes for auto-scaling
     */
    @JvmName("uheactoqulrlhede")
    public suspend fun minCount(`value`: Output<Int>) {
        this.minCount = value
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("auwbgxupkyhbgkbo")
    public suspend fun mode(`value`: Output<Either<String, Mode>>) {
        this.mode = value
    }

    /**
     * @param value Unique name of the agent pool profile in the context of the subscription and resource group.
     */
    @JvmName("kbjwqcpntntxuhlu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of node image
     */
    @JvmName("hlbuntbhwjgkgtxs")
    public suspend fun nodeImageVersion(`value`: Output<String>) {
        this.nodeImageVersion = value
    }

    /**
     * @param value NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("bojdwqfhuycaxyma")
    public suspend fun nodeLabels(`value`: Output<Map<String, String>>) {
        this.nodeLabels = value
    }

    /**
     * @param value NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("pbybbkvyboxsyqra")
    public suspend fun nodeTaints(`value`: Output<List<String>>) {
        this.nodeTaints = value
    }

    @JvmName("oclofucskkqsydqb")
    public suspend fun nodeTaints(vararg values: Output<String>) {
        this.nodeTaints = Output.all(values.asList())
    }

    /**
     * @param values NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("auujwsaxllwagskc")
    public suspend fun nodeTaints(values: List<Output<String>>) {
        this.nodeTaints = Output.all(values)
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("mcjonmmvsywkttho")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value VmSize - The size of the agent pool VMs.
     */
    @JvmName("wbcjngxcyqqrdjcx")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("dtbjmpdcsepicavy")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("bwsprdbqnusypuuw")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("kjdkdafwvbysxuqq")
    public suspend fun cloudProviderProfile(`value`: CloudProviderProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudProviderProfile = mapped
    }

    /**
     * @param argument The underlying cloud infra provider properties.
     */
    @JvmName("haefccnudrujhxrq")
    public suspend
    fun cloudProviderProfile(argument: suspend CloudProviderProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudProviderProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudProviderProfile = mapped
    }

    /**
     * @param value Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JvmName("ladkmgyswikqjxej")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The maximum number of nodes for auto-scaling
     */
    @JvmName("mtnvmslyckclffpn")
    public suspend fun maxCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCount = mapped
    }

    /**
     * @param value The maximum number of pods that can run on a node.
     */
    @JvmName("fbdnwemxrvxxfybp")
    public suspend fun maxPods(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPods = mapped
    }

    /**
     * @param value The minimum number of nodes for auto-scaling
     */
    @JvmName("ldgaxlehpmwsymoo")
    public suspend fun minCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCount = mapped
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("pikovymtfuqepeif")
    public suspend fun mode(`value`: Either<String, Mode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("wmgmdodmxloajkdj")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("dbhxliwyruxvvegl")
    public fun mode(`value`: Mode) {
        val toBeMapped = Either.ofRight<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Unique name of the agent pool profile in the context of the subscription and resource group.
     */
    @JvmName("kvppcunhyoprcgku")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of node image
     */
    @JvmName("mfmgvcfpwhvhxwis")
    public suspend fun nodeImageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeImageVersion = mapped
    }

    /**
     * @param value NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("jnakyntprqwqkhue")
    public suspend fun nodeLabels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeLabels = mapped
    }

    /**
     * @param values NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("atgjqhclajthildv")
    public fun nodeLabels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeLabels = mapped
    }

    /**
     * @param value NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("vbolhemergejexyh")
    public suspend fun nodeTaints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTaints = mapped
    }

    /**
     * @param values NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("mbqjimyuxiwsauik")
    public suspend fun nodeTaints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeTaints = mapped
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("rtpwdedlfsycodau")
    public suspend fun osType(`value`: Either<String, OsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("ndkhbgwupchbotmn")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("mawyhynjjppykgrq")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value VmSize - The size of the agent pool VMs.
     */
    @JvmName("xohfwlqkowdfihiv")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): NamedAgentPoolProfileArgs = NamedAgentPoolProfileArgs(
        availabilityZones = availabilityZones,
        cloudProviderProfile = cloudProviderProfile,
        count = count,
        maxCount = maxCount,
        maxPods = maxPods,
        minCount = minCount,
        mode = mode,
        name = name,
        nodeImageVersion = nodeImageVersion,
        nodeLabels = nodeLabels,
        nodeTaints = nodeTaints,
        osType = osType,
        vmSize = vmSize,
    )
}
