@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesVmwareStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datacenter Name of the datacenter in VSphere
 * @property datastore Name of the datastore in VSphere
 * @property folder Name of the folder in VSphere
 * @property resourcePool Name of the resource pool in VSphere
 */
public data class StorageSpacesPropertiesVmwareStorageProfileArgs(
    public val datacenter: Output<String>? = null,
    public val datastore: Output<String>? = null,
    public val folder: Output<String>? = null,
    public val resourcePool: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesVmwareStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesVmwareStorageProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesVmwareStorageProfileArgs.builder()
            .datacenter(datacenter?.applyValue({ args0 -> args0 }))
            .datastore(datastore?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0 }))
            .resourcePool(resourcePool?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageSpacesPropertiesVmwareStorageProfileArgs].
 */
@PulumiTagMarker
public class StorageSpacesPropertiesVmwareStorageProfileArgsBuilder internal constructor() {
    private var datacenter: Output<String>? = null

    private var datastore: Output<String>? = null

    private var folder: Output<String>? = null

    private var resourcePool: Output<String>? = null

    /**
     * @param value Name of the datacenter in VSphere
     */
    @JvmName("swdftdiuyactaglw")
    public suspend fun datacenter(`value`: Output<String>) {
        this.datacenter = value
    }

    /**
     * @param value Name of the datastore in VSphere
     */
    @JvmName("covfgptjaqwtquhl")
    public suspend fun datastore(`value`: Output<String>) {
        this.datastore = value
    }

    /**
     * @param value Name of the folder in VSphere
     */
    @JvmName("dtnamhxchsevpnhf")
    public suspend fun folder(`value`: Output<String>) {
        this.folder = value
    }

    /**
     * @param value Name of the resource pool in VSphere
     */
    @JvmName("uwonsbtecvcqbpye")
    public suspend fun resourcePool(`value`: Output<String>) {
        this.resourcePool = value
    }

    /**
     * @param value Name of the datacenter in VSphere
     */
    @JvmName("vrwqhysoruhkowxj")
    public suspend fun datacenter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datacenter = mapped
    }

    /**
     * @param value Name of the datastore in VSphere
     */
    @JvmName("rmjfyrhjtdsrvnii")
    public suspend fun datastore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastore = mapped
    }

    /**
     * @param value Name of the folder in VSphere
     */
    @JvmName("bwlqngnlralmkcfu")
    public suspend fun folder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param value Name of the resource pool in VSphere
     */
    @JvmName("arpgassdsyyekcwt")
    public suspend fun resourcePool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePool = mapped
    }

    internal fun build(): StorageSpacesPropertiesVmwareStorageProfileArgs =
        StorageSpacesPropertiesVmwareStorageProfileArgs(
            datacenter = datacenter,
            datastore = datastore,
            folder = folder,
            resourcePool = resourcePool,
        )
}
