@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesNetworkCloudArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Infra network profile for the NetworkCloud platform
 * @property networkId The ARM ID of Network Cloud Network Resource to Associate with this VirtualNetwork
 */
public data class VirtualNetworksPropertiesNetworkCloudArgs(
    public val networkId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesNetworkCloudArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesNetworkCloudArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesNetworkCloudArgs.builder()
            .networkId(networkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworksPropertiesNetworkCloudArgs].
 */
@PulumiTagMarker
public class VirtualNetworksPropertiesNetworkCloudArgsBuilder internal constructor() {
    private var networkId: Output<String>? = null

    /**
     * @param value The ARM ID of Network Cloud Network Resource to Associate with this VirtualNetwork
     */
    @JvmName("kjpwwyecxswyjamu")
    public suspend fun networkId(`value`: Output<String>) {
        this.networkId = value
    }

    /**
     * @param value The ARM ID of Network Cloud Network Resource to Associate with this VirtualNetwork
     */
    @JvmName("whhdesydshhlcnft")
    public suspend fun networkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkId = mapped
    }

    internal fun build(): VirtualNetworksPropertiesNetworkCloudArgs =
        VirtualNetworksPropertiesNetworkCloudArgs(
            networkId = networkId,
        )
}
