@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmwareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Infra network profile for VMware platform
 * @property segmentName Name of the network segment in VSphere
 */
public data class VirtualNetworksPropertiesVmwareArgs(
    public val segmentName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmwareArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmwareArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmwareArgs.builder()
            .segmentName(segmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworksPropertiesVmwareArgs].
 */
@PulumiTagMarker
public class VirtualNetworksPropertiesVmwareArgsBuilder internal constructor() {
    private var segmentName: Output<String>? = null

    /**
     * @param value Name of the network segment in VSphere
     */
    @JvmName("mmdbxrvqrbyljmol")
    public suspend fun segmentName(`value`: Output<String>) {
        this.segmentName = value
    }

    /**
     * @param value Name of the network segment in VSphere
     */
    @JvmName("psuohrhtknkivspj")
    public suspend fun segmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentName = mapped
    }

    internal fun build(): VirtualNetworksPropertiesVmwareArgs = VirtualNetworksPropertiesVmwareArgs(
        segmentName = segmentName,
    )
}
