@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Status of the addon
 * @property errorMessage ErrorMessage will be set in the event that there is a terminal problem reconciling the AddOn and will contain a more verbose string suitable for logging and human consumption.
 * @property phase Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
 * @property ready
 */
public data class AddonStatusResponse(
    public val errorMessage: String? = null,
    public val phase: String? = null,
    public val ready: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.AddonStatusResponse):
            AddonStatusResponse = AddonStatusResponse(
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            phase = javaType.phase().map({ args0 -> args0 }).orElse(null),
            ready = javaType.ready().map({ args0 -> args0 }).orElse(null),
        )
    }
}
