@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InfraStorageProfile - List of infra storage profiles for the provisioned cluster
 * @property storageSpaceIds Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
 */
public data class CloudProviderProfileResponseInfraStorageProfile(
    public val storageSpaceIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.CloudProviderProfileResponseInfraStorageProfile):
            CloudProviderProfileResponseInfraStorageProfile =
            CloudProviderProfileResponseInfraStorageProfile(
                storageSpaceIds = javaType.storageSpaceIds().map({ args0 -> args0 }),
            )
    }
}
