@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The storageSpaces resource definition.
 * @property extendedLocation
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property properties HybridAKSStorageSpec defines the desired state of HybridAKSStorage
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStorageSpaceRetrieveResult(
    public val extendedLocation: StorageSpacesResponseExtendedLocation? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: StorageSpacesPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.GetStorageSpaceRetrieveResult):
            GetStorageSpaceRetrieveResult = GetStorageSpaceRetrieveResult(
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesResponseExtendedLocation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
