@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin

import com.pulumi.azurenative.hybriddata.DataStoreArgs.builder
import com.pulumi.azurenative.hybriddata.kotlin.enums.State
import com.pulumi.azurenative.hybriddata.kotlin.inputs.CustomerSecretArgs
import com.pulumi.azurenative.hybriddata.kotlin.inputs.CustomerSecretArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data store.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### DataStores_CreateOrUpdate_DataSinkPUT162
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataStore = new AzureNative.HybridData.DataStore("dataStore", new()
 *     {
 *         CustomerSecrets = new[]
 *         {
 *             new AzureNative.HybridData.Inputs.CustomerSecretArgs
 *             {
 *                 Algorithm = AzureNative.HybridData.SupportedAlgorithm.RSA1_5,
 *                 KeyIdentifier = "StorageAccountAccessKey",
 *                 KeyValue = "Of4H9eF03G8QuxvkZQEbFWv3YdN3U//WugzuqReQekbXXQyg+QSicVKrwSOOKVi1zWMYGbKg7d5/ES2gdz+O5ZEw89bvE4mJD/wQmkIsqhPnbN0gyVK6nZePXVUU1A+UzjLfvhSA6KyUQfzNAZ5/TLt6fo1JyQrKTtkvnkLFyfv1AqBZ+dw8JK3RZi/rEN8HD3R3qsBwUYfyEuGLGiujy2CGrr/1uPiUVMR6QuFWRsjm39eMSHa4maLg4tQ0IY/jIy8rMlx3KjF3CcCbPzAqEq5vXy37wkjZbus771te1gLSrzcpVKIMg4DrmgaoJ02jAu+izBjNgLXAFPSUneQ8yw==:ezMkh4PMhCnjJtYkpTaP0SdblP5VAeRe4glW2PgIzICHw3T8ZyGDoaTrCv4/m5wtcEhWdtxhta+j1MQWlK5MIA+hvf8QjIDIjQv696ov5y+pcFe/upd2ekGOei7FCwB2u7I8WnkAtIKTUkf6eDQBZXm26DjfG1Dlc+Mjjq+AerukEa6WpOyqrD7Qub26Pgmj4AsuBx19X1EAmTZacubkoiNagXM8V+IDanHOhLMvfgQ7rw8oZhWfofxi4m+eJqjOXXaqSyorNK8UEcqP6P9pDP8AN8ulXEx6rZy2B5Oi0vSV+wlRLbUuQslga4ItOGxctW/ZX8uWozt+5A3k4URt6A==",
 *             },
 *             new AzureNative.HybridData.Inputs.CustomerSecretArgs
 *             {
 *                 Algorithm = AzureNative.HybridData.SupportedAlgorithm.RSA1_5,
 *                 KeyIdentifier = "StorageAccountAccessKeyForQueue",
 *                 KeyValue = "Of4H9eF03G8QuxvkZQEbFWv3YdN3U//WugzuqReQekbXXQyg+QSicVKrwSOOKVi1zWMYGbKg7d5/ES2gdz+O5ZEw89bvE4mJD/wQmkIsqhPnbN0gyVK6nZePXVUU1A+UzjLfvhSA6KyUQfzNAZ5/TLt6fo1JyQrKTtkvnkLFyfv1AqBZ+dw8JK3RZi/rEN8HD3R3qsBwUYfyEuGLGiujy2CGrr/1uPiUVMR6QuFWRsjm39eMSHa4maLg4tQ0IY/jIy8rMlx3KjF3CcCbPzAqEq5vXy37wkjZbus771te1gLSrzcpVKIMg4DrmgaoJ02jAu+izBjNgLXAFPSUneQ8yw==:ezMkh4PMhCnjJtYkpTaP0SdblP5VAeRe4glW2PgIzICHw3T8ZyGDoaTrCv4/m5wtcEhWdtxhta+j1MQWlK5MIA+hvf8QjIDIjQv696ov5y+pcFe/upd2ekGOei7FCwB2u7I8WnkAtIKTUkf6eDQBZXm26DjfG1Dlc+Mjjq+AerukEa6WpOyqrD7Qub26Pgmj4AsuBx19X1EAmTZacubkoiNagXM8V+IDanHOhLMvfgQ7rw8oZhWfofxi4m+eJqjOXXaqSyorNK8UEcqP6P9pDP8AN8ulXEx6rZy2B5Oi0vSV+wlRLbUuQslga4ItOGxctW/ZX8uWozt+5A3k4URt6A==",
 *             },
 *         },
 *         DataManagerName = "TestAzureSDKOperations",
 *         DataStoreName = "TestAzureStorage1",
 *         DataStoreTypeId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStoreTypes/AzureStorageAccount",
 *         ExtendedProperties =
 *         {
 *             { "extendedSaKey", null },
 *             { "extendedSaName", "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink" },
 *             { "storageAccountNameForQueue", "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink" },
 *         },
 *         RepositoryId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         State = AzureNative.HybridData.State.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybriddata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybriddata.NewDataStore(ctx, "dataStore", &hybriddata.DataStoreArgs{
 * 			CustomerSecrets: []hybriddata.CustomerSecretArgs{
 * 				{
 * 					Algorithm:     hybriddata.SupportedAlgorithm_RSA1_5,
 * 					KeyIdentifier: pulumi.String("StorageAccountAccessKey"),
 * 					KeyValue:      pulumi.String("Of4H9eF03G8QuxvkZQEbFWv3YdN3U//WugzuqReQekbXXQyg+QSicVKrwSOOKVi1zWMYGbKg7d5/ES2gdz+O5ZEw89bvE4mJD/wQmkIsqhPnbN0gyVK6nZePXVUU1A+UzjLfvhSA6KyUQfzNAZ5/TLt6fo1JyQrKTtkvnkLFyfv1AqBZ+dw8JK3RZi/rEN8HD3R3qsBwUYfyEuGLGiujy2CGrr/1uPiUVMR6QuFWRsjm39eMSHa4maLg4tQ0IY/jIy8rMlx3KjF3CcCbPzAqEq5vXy37wkjZbus771te1gLSrzcpVKIMg4DrmgaoJ02jAu+izBjNgLXAFPSUneQ8yw==:ezMkh4PMhCnjJtYkpTaP0SdblP5VAeRe4glW2PgIzICHw3T8ZyGDoaTrCv4/m5wtcEhWdtxhta+j1MQWlK5MIA+hvf8QjIDIjQv696ov5y+pcFe/upd2ekGOei7FCwB2u7I8WnkAtIKTUkf6eDQBZXm26DjfG1Dlc+Mjjq+AerukEa6WpOyqrD7Qub26Pgmj4AsuBx19X1EAmTZacubkoiNagXM8V+IDanHOhLMvfgQ7rw8oZhWfofxi4m+eJqjOXXaqSyorNK8UEcqP6P9pDP8AN8ulXEx6rZy2B5Oi0vSV+wlRLbUuQslga4ItOGxctW/ZX8uWozt+5A3k4URt6A=="),
 * 				},
 * 				{
 * 					Algorithm:     hybriddata.SupportedAlgorithm_RSA1_5,
 * 					KeyIdentifier: pulumi.String("StorageAccountAccessKeyForQueue"),
 * 					KeyValue:      pulumi.String("Of4H9eF03G8QuxvkZQEbFWv3YdN3U//WugzuqReQekbXXQyg+QSicVKrwSOOKVi1zWMYGbKg7d5/ES2gdz+O5ZEw89bvE4mJD/wQmkIsqhPnbN0gyVK6nZePXVUU1A+UzjLfvhSA6KyUQfzNAZ5/TLt6fo1JyQrKTtkvnkLFyfv1AqBZ+dw8JK3RZi/rEN8HD3R3qsBwUYfyEuGLGiujy2CGrr/1uPiUVMR6QuFWRsjm39eMSHa4maLg4tQ0IY/jIy8rMlx3KjF3CcCbPzAqEq5vXy37wkjZbus771te1gLSrzcpVKIMg4DrmgaoJ02jAu+izBjNgLXAFPSUneQ8yw==:ezMkh4PMhCnjJtYkpTaP0SdblP5VAeRe4glW2PgIzICHw3T8ZyGDoaTrCv4/m5wtcEhWdtxhta+j1MQWlK5MIA+hvf8QjIDIjQv696ov5y+pcFe/upd2ekGOei7FCwB2u7I8WnkAtIKTUkf6eDQBZXm26DjfG1Dlc+Mjjq+AerukEa6WpOyqrD7Qub26Pgmj4AsuBx19X1EAmTZacubkoiNagXM8V+IDanHOhLMvfgQ7rw8oZhWfofxi4m+eJqjOXXaqSyorNK8UEcqP6P9pDP8AN8ulXEx6rZy2B5Oi0vSV+wlRLbUuQslga4ItOGxctW/ZX8uWozt+5A3k4URt6A=="),
 * 				},
 * 			},
 * 			DataManagerName: pulumi.String("TestAzureSDKOperations"),
 * 			DataStoreName:   pulumi.String("TestAzureStorage1"),
 * 			DataStoreTypeId: pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStoreTypes/AzureStorageAccount"),
 * 			ExtendedProperties: pulumi.Any{
 * 				ExtendedSaKey:              nil,
 * 				ExtendedSaName:             "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink",
 * 				StorageAccountNameForQueue: "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink",
 * 			},
 * 			RepositoryId:      pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			State:             hybriddata.StateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybriddata.DataStore;
 * import com.pulumi.azurenative.hybriddata.DataStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataStore = new DataStore("dataStore", DataStoreArgs.builder()
 *             .customerSecrets(
 *                 Map.ofEntries(
 *                     Map.entry("algorithm", "RSA1_5"),
 *                     Map.entry("keyIdentifier", "StorageAccountAccessKey"),
 *                     Map.entry("keyValue", "Of4H9eF03G8QuxvkZQEbFWv3YdN3U//WugzuqReQekbXXQyg+QSicVKrwSOOKVi1zWMYGbKg7d5/ES2gdz+O5ZEw89bvE4mJD/wQmkIsqhPnbN0gyVK6nZePXVUU1A+UzjLfvhSA6KyUQfzNAZ5/TLt6fo1JyQrKTtkvnkLFyfv1AqBZ+dw8JK3RZi/rEN8HD3R3qsBwUYfyEuGLGiujy2CGrr/1uPiUVMR6QuFWRsjm39eMSHa4maLg4tQ0IY/jIy8rMlx3KjF3CcCbPzAqEq5vXy37wkjZbus771te1gLSrzcpVKIMg4DrmgaoJ02jAu+izBjNgLXAFPSUneQ8yw==:ezMkh4PMhCnjJtYkpTaP0SdblP5VAeRe4glW2PgIzICHw3T8ZyGDoaTrCv4/m5wtcEhWdtxhta+j1MQWlK5MIA+hvf8QjIDIjQv696ov5y+pcFe/upd2ekGOei7FCwB2u7I8WnkAtIKTUkf6eDQBZXm26DjfG1Dlc+Mjjq+AerukEa6WpOyqrD7Qub26Pgmj4AsuBx19X1EAmTZacubkoiNagXM8V+IDanHOhLMvfgQ7rw8oZhWfofxi4m+eJqjOXXaqSyorNK8UEcqP6P9pDP8AN8ulXEx6rZy2B5Oi0vSV+wlRLbUuQslga4ItOGxctW/ZX8uWozt+5A3k4URt6A==")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("algorithm", "RSA1_5"),
 *                     Map.entry("keyIdentifier", "StorageAccountAccessKeyForQueue"),
 *                     Map.entry("keyValue", "Of4H9eF03G8QuxvkZQEbFWv3YdN3U//WugzuqReQekbXXQyg+QSicVKrwSOOKVi1zWMYGbKg7d5/ES2gdz+O5ZEw89bvE4mJD/wQmkIsqhPnbN0gyVK6nZePXVUU1A+UzjLfvhSA6KyUQfzNAZ5/TLt6fo1JyQrKTtkvnkLFyfv1AqBZ+dw8JK3RZi/rEN8HD3R3qsBwUYfyEuGLGiujy2CGrr/1uPiUVMR6QuFWRsjm39eMSHa4maLg4tQ0IY/jIy8rMlx3KjF3CcCbPzAqEq5vXy37wkjZbus771te1gLSrzcpVKIMg4DrmgaoJ02jAu+izBjNgLXAFPSUneQ8yw==:ezMkh4PMhCnjJtYkpTaP0SdblP5VAeRe4glW2PgIzICHw3T8ZyGDoaTrCv4/m5wtcEhWdtxhta+j1MQWlK5MIA+hvf8QjIDIjQv696ov5y+pcFe/upd2ekGOei7FCwB2u7I8WnkAtIKTUkf6eDQBZXm26DjfG1Dlc+Mjjq+AerukEa6WpOyqrD7Qub26Pgmj4AsuBx19X1EAmTZacubkoiNagXM8V+IDanHOhLMvfgQ7rw8oZhWfofxi4m+eJqjOXXaqSyorNK8UEcqP6P9pDP8AN8ulXEx6rZy2B5Oi0vSV+wlRLbUuQslga4ItOGxctW/ZX8uWozt+5A3k4URt6A==")
 *                 ))
 *             .dataManagerName("TestAzureSDKOperations")
 *             .dataStoreName("TestAzureStorage1")
 *             .dataStoreTypeId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStoreTypes/AzureStorageAccount")
 *             .extendedProperties(Map.ofEntries(
 *                 Map.entry("extendedSaKey", null),
 *                 Map.entry("extendedSaName", "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink"),
 *                 Map.entry("storageAccountNameForQueue", "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink")
 *             ))
 *             .repositoryId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.Storage/storageAccounts/dmsdatasink")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ### DataStores_CreateOrUpdate_DataSourcePUT162
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataStore = new AzureNative.HybridData.DataStore("dataStore", new()
 *     {
 *         CustomerSecrets = new[]
 *         {
 *             new AzureNative.HybridData.Inputs.CustomerSecretArgs
 *             {
 *                 Algorithm = AzureNative.HybridData.SupportedAlgorithm.RSA1_5,
 *                 KeyIdentifier = "ServiceEncryptionKey",
 *                 KeyValue = "EVuEBV40qv23xDRL4NZBuMms4e3So6ikHjrQYRvG9NloqxdgPOg+ZYzpho5lytI4fmv0ANmRIvDiDboRXcUVSjbB9T2gm19fMIuwZa4FK2+LYEgMqKK1GaLkk7xC8f5IeFUXLo6KyBBpaAiayTnWDcHuYEpMiGrV7trDDcbhMRefO3CHecmH3Z7ye8L0RQ/e7WW8GlCKZj3m0BaG7OrJgjai8gyDfMfGAG5rTqEhDVh2hLQ+TjvUjcOFwHvJusqKTENtbJTNQYmL9wZXsnwBvUwxqrGieILNB7V3GD1Ow9OiV0UCDW1e9LnMueukg+l7YJCU9FUhIPh/nSif6p32zw==:jCfio+pDtY3BSPZDpDJ0L6QdXLYMeOmxaFWtYTOZkNqNTgT8Loc/KSQRjtWS5K4N4btbznuSJ/dzg0aZEzlXgKDSuZgMfd4Ch92ZwAC/BkeCmVrTjiKJsoQXO1IICCUf7GHGBbYnnpsNJcEn4vyc9NXyKwOBjeU+I9AyK7PtYiC03RLpTS6xttFCICteBV0uoBHAiV0chZ5VIIUUMjO9u8EhHqRY7NNcGbWdVJeAb6J3vH4E/DHkQj+DXlpjcLvmK/uqBwxfNju30RJhR04Nmz6zcv/zTcvS0uN5hEPQoHLyv84hjnc4omg/gmNjo2cDW64QxA3RTJ5Sl///4xTBkg==",
 *             },
 *         },
 *         DataManagerName = "TestAzureSDKOperations",
 *         DataStoreName = "TestStorSimpleSource1",
 *         DataStoreTypeId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStoreTypes/StorSimple8000Series",
 *         ExtendedProperties =
 *         {
 *             { "extendedSaKey", null },
 *             { "resourceId", "/subscriptions/c5fc377d-0085-41b9-86b7-cc96dc56d1e9/resourceGroups/ForDMS/providers/Microsoft.StorSimple/managers/BLR8600" },
 *         },
 *         RepositoryId = "/subscriptions/c5fc377d-0085-41b9-86b7-cc96dc56d1e9/resourceGroups/ForDMS/providers/Microsoft.StorSimple/managers/BLR8600",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         State = AzureNative.HybridData.State.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybriddata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybriddata.NewDataStore(ctx, "dataStore", &hybriddata.DataStoreArgs{
 * 			CustomerSecrets: []hybriddata.CustomerSecretArgs{
 * 				{
 * 					Algorithm:     hybriddata.SupportedAlgorithm_RSA1_5,
 * 					KeyIdentifier: pulumi.String("ServiceEncryptionKey"),
 * 					KeyValue:      pulumi.String("EVuEBV40qv23xDRL4NZBuMms4e3So6ikHjrQYRvG9NloqxdgPOg+ZYzpho5lytI4fmv0ANmRIvDiDboRXcUVSjbB9T2gm19fMIuwZa4FK2+LYEgMqKK1GaLkk7xC8f5IeFUXLo6KyBBpaAiayTnWDcHuYEpMiGrV7trDDcbhMRefO3CHecmH3Z7ye8L0RQ/e7WW8GlCKZj3m0BaG7OrJgjai8gyDfMfGAG5rTqEhDVh2hLQ+TjvUjcOFwHvJusqKTENtbJTNQYmL9wZXsnwBvUwxqrGieILNB7V3GD1Ow9OiV0UCDW1e9LnMueukg+l7YJCU9FUhIPh/nSif6p32zw==:jCfio+pDtY3BSPZDpDJ0L6QdXLYMeOmxaFWtYTOZkNqNTgT8Loc/KSQRjtWS5K4N4btbznuSJ/dzg0aZEzlXgKDSuZgMfd4Ch92ZwAC/BkeCmVrTjiKJsoQXO1IICCUf7GHGBbYnnpsNJcEn4vyc9NXyKwOBjeU+I9AyK7PtYiC03RLpTS6xttFCICteBV0uoBHAiV0chZ5VIIUUMjO9u8EhHqRY7NNcGbWdVJeAb6J3vH4E/DHkQj+DXlpjcLvmK/uqBwxfNju30RJhR04Nmz6zcv/zTcvS0uN5hEPQoHLyv84hjnc4omg/gmNjo2cDW64QxA3RTJ5Sl///4xTBkg=="),
 * 				},
 * 			},
 * 			DataManagerName: pulumi.String("TestAzureSDKOperations"),
 * 			DataStoreName:   pulumi.String("TestStorSimpleSource1"),
 * 			DataStoreTypeId: pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStoreTypes/StorSimple8000Series"),
 * 			ExtendedProperties: pulumi.Any{
 * 				ExtendedSaKey: nil,
 * 				ResourceId:    "/subscriptions/c5fc377d-0085-41b9-86b7-cc96dc56d1e9/resourceGroups/ForDMS/providers/Microsoft.StorSimple/managers/BLR8600",
 * 			},
 * 			RepositoryId:      pulumi.String("/subscriptions/c5fc377d-0085-41b9-86b7-cc96dc56d1e9/resourceGroups/ForDMS/providers/Microsoft.StorSimple/managers/BLR8600"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			State:             hybriddata.StateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybriddata.DataStore;
 * import com.pulumi.azurenative.hybriddata.DataStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataStore = new DataStore("dataStore", DataStoreArgs.builder()
 *             .customerSecrets(Map.ofEntries(
 *                 Map.entry("algorithm", "RSA1_5"),
 *                 Map.entry("keyIdentifier", "ServiceEncryptionKey"),
 *                 Map.entry("keyValue", "EVuEBV40qv23xDRL4NZBuMms4e3So6ikHjrQYRvG9NloqxdgPOg+ZYzpho5lytI4fmv0ANmRIvDiDboRXcUVSjbB9T2gm19fMIuwZa4FK2+LYEgMqKK1GaLkk7xC8f5IeFUXLo6KyBBpaAiayTnWDcHuYEpMiGrV7trDDcbhMRefO3CHecmH3Z7ye8L0RQ/e7WW8GlCKZj3m0BaG7OrJgjai8gyDfMfGAG5rTqEhDVh2hLQ+TjvUjcOFwHvJusqKTENtbJTNQYmL9wZXsnwBvUwxqrGieILNB7V3GD1Ow9OiV0UCDW1e9LnMueukg+l7YJCU9FUhIPh/nSif6p32zw==:jCfio+pDtY3BSPZDpDJ0L6QdXLYMeOmxaFWtYTOZkNqNTgT8Loc/KSQRjtWS5K4N4btbznuSJ/dzg0aZEzlXgKDSuZgMfd4Ch92ZwAC/BkeCmVrTjiKJsoQXO1IICCUf7GHGBbYnnpsNJcEn4vyc9NXyKwOBjeU+I9AyK7PtYiC03RLpTS6xttFCICteBV0uoBHAiV0chZ5VIIUUMjO9u8EhHqRY7NNcGbWdVJeAb6J3vH4E/DHkQj+DXlpjcLvmK/uqBwxfNju30RJhR04Nmz6zcv/zTcvS0uN5hEPQoHLyv84hjnc4omg/gmNjo2cDW64QxA3RTJ5Sl///4xTBkg==")
 *             ))
 *             .dataManagerName("TestAzureSDKOperations")
 *             .dataStoreName("TestStorSimpleSource1")
 *             .dataStoreTypeId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStoreTypes/StorSimple8000Series")
 *             .extendedProperties(Map.ofEntries(
 *                 Map.entry("extendedSaKey", null),
 *                 Map.entry("resourceId", "/subscriptions/c5fc377d-0085-41b9-86b7-cc96dc56d1e9/resourceGroups/ForDMS/providers/Microsoft.StorSimple/managers/BLR8600")
 *             ))
 *             .repositoryId("/subscriptions/c5fc377d-0085-41b9-86b7-cc96dc56d1e9/resourceGroups/ForDMS/providers/Microsoft.StorSimple/managers/BLR8600")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybriddata:DataStore TestStorSimpleSource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridData/dataManagers/{dataManagerName}/dataStores/{dataStoreName}
 * ```
 * @property customerSecrets List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
 * @property dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property dataStoreName The data store/repository name to be created or updated.
 * @property dataStoreTypeId The arm id of the data store type.
 * @property extendedProperties A generic json used differently by each data source type.
 * @property repositoryId Arm Id for the manager resource to which the data source is associated. This is optional.
 * @property resourceGroupName The Resource Group Name
 * @property state State of the data source.
 */
public data class DataStoreArgs(
    public val customerSecrets: Output<List<CustomerSecretArgs>>? = null,
    public val dataManagerName: Output<String>? = null,
    public val dataStoreName: Output<String>? = null,
    public val dataStoreTypeId: Output<String>? = null,
    public val extendedProperties: Output<Any>? = null,
    public val repositoryId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<State>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.DataStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.DataStoreArgs =
        com.pulumi.azurenative.hybriddata.DataStoreArgs.builder()
            .customerSecrets(
                customerSecrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataManagerName(dataManagerName?.applyValue({ args0 -> args0 }))
            .dataStoreName(dataStoreName?.applyValue({ args0 -> args0 }))
            .dataStoreTypeId(dataStoreTypeId?.applyValue({ args0 -> args0 }))
            .extendedProperties(extendedProperties?.applyValue({ args0 -> args0 }))
            .repositoryId(repositoryId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataStoreArgs].
 */
@PulumiTagMarker
public class DataStoreArgsBuilder internal constructor() {
    private var customerSecrets: Output<List<CustomerSecretArgs>>? = null

    private var dataManagerName: Output<String>? = null

    private var dataStoreName: Output<String>? = null

    private var dataStoreTypeId: Output<String>? = null

    private var extendedProperties: Output<Any>? = null

    private var repositoryId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<State>? = null

    /**
     * @param value List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("cmldfaswnbagbqsh")
    public suspend fun customerSecrets(`value`: Output<List<CustomerSecretArgs>>) {
        this.customerSecrets = value
    }

    @JvmName("qebgqsdcbcukjocj")
    public suspend fun customerSecrets(vararg values: Output<CustomerSecretArgs>) {
        this.customerSecrets = Output.all(values.asList())
    }

    /**
     * @param values List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("iaqrpqpjdpwiefvl")
    public suspend fun customerSecrets(values: List<Output<CustomerSecretArgs>>) {
        this.customerSecrets = Output.all(values)
    }

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("lhojfjfumrqhuyte")
    public suspend fun dataManagerName(`value`: Output<String>) {
        this.dataManagerName = value
    }

    /**
     * @param value The data store/repository name to be created or updated.
     */
    @JvmName("aowuedhxhrdcrane")
    public suspend fun dataStoreName(`value`: Output<String>) {
        this.dataStoreName = value
    }

    /**
     * @param value The arm id of the data store type.
     */
    @JvmName("sxcgduqvkqsdspma")
    public suspend fun dataStoreTypeId(`value`: Output<String>) {
        this.dataStoreTypeId = value
    }

    /**
     * @param value A generic json used differently by each data source type.
     */
    @JvmName("bvcgtvhoevraddtk")
    public suspend fun extendedProperties(`value`: Output<Any>) {
        this.extendedProperties = value
    }

    /**
     * @param value Arm Id for the manager resource to which the data source is associated. This is optional.
     */
    @JvmName("xwvvipvgcloewpuy")
    public suspend fun repositoryId(`value`: Output<String>) {
        this.repositoryId = value
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("ophejknqnnwrcdgd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value State of the data source.
     */
    @JvmName("pxwaiymfsawktbye")
    public suspend fun state(`value`: Output<State>) {
        this.state = value
    }

    /**
     * @param value List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("anmnhwvoyalcucgg")
    public suspend fun customerSecrets(`value`: List<CustomerSecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerSecrets = mapped
    }

    /**
     * @param argument List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("kfwwahpmodpehktc")
    public suspend fun customerSecrets(argument: List<suspend CustomerSecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomerSecretArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customerSecrets = mapped
    }

    /**
     * @param argument List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("bfejgkijjnyhbxcp")
    public suspend fun customerSecrets(
        vararg
        argument: suspend CustomerSecretArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomerSecretArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customerSecrets = mapped
    }

    /**
     * @param argument List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("chomgqhbmxtpecha")
    public suspend fun customerSecrets(argument: suspend CustomerSecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomerSecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customerSecrets = mapped
    }

    /**
     * @param values List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("rioolrxcnnqygrwx")
    public suspend fun customerSecrets(vararg values: CustomerSecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerSecrets = mapped
    }

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("ubkltraqbkfccxxm")
    public suspend fun dataManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataManagerName = mapped
    }

    /**
     * @param value The data store/repository name to be created or updated.
     */
    @JvmName("sspvljnwxhxyajsn")
    public suspend fun dataStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataStoreName = mapped
    }

    /**
     * @param value The arm id of the data store type.
     */
    @JvmName("mykjdipldhqmjdmq")
    public suspend fun dataStoreTypeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataStoreTypeId = mapped
    }

    /**
     * @param value A generic json used differently by each data source type.
     */
    @JvmName("riricaloxocjsxwd")
    public suspend fun extendedProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param value Arm Id for the manager resource to which the data source is associated. This is optional.
     */
    @JvmName("yambctmahbjddcbm")
    public suspend fun repositoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryId = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("asdcbuqoypgcuagh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value State of the data source.
     */
    @JvmName("uybtrtiirgyeqqex")
    public suspend fun state(`value`: State?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): DataStoreArgs = DataStoreArgs(
        customerSecrets = customerSecrets,
        dataManagerName = dataManagerName,
        dataStoreName = dataStoreName,
        dataStoreTypeId = dataStoreTypeId,
        extendedProperties = extendedProperties,
        repositoryId = repositoryId,
        resourceGroupName = resourceGroupName,
        state = state,
    )
}
