@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin

import com.pulumi.azurenative.hybriddata.JobDefinitionArgs.builder
import com.pulumi.azurenative.hybriddata.kotlin.enums.RunLocation
import com.pulumi.azurenative.hybriddata.kotlin.enums.State
import com.pulumi.azurenative.hybriddata.kotlin.enums.UserConfirmation
import com.pulumi.azurenative.hybriddata.kotlin.inputs.CustomerSecretArgs
import com.pulumi.azurenative.hybriddata.kotlin.inputs.CustomerSecretArgsBuilder
import com.pulumi.azurenative.hybriddata.kotlin.inputs.ScheduleArgs
import com.pulumi.azurenative.hybriddata.kotlin.inputs.ScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Job Definition.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### JobDefinitions_CreateOrUpdatePUT83
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobDefinition = new AzureNative.HybridData.JobDefinition("jobDefinition", new()
 *     {
 *         DataManagerName = "TestAzureSDKOperations",
 *         DataServiceInput =
 *         {
 *             { "AzureStorageType", "Blob" },
 *             { "BackupChoice", "UseExistingLatest" },
 *             { "ContainerName", "containerfromtest" },
 *             { "DeviceName", "8600-SHG0997877L71FC" },
 *             { "FileNameFilter", "*" },
 *             { "IsDirectoryMode", false },
 *             { "RootDirectories", new[]
 *             {
 *                 "\\",
 *             } },
 *             { "VolumeNames", new[]
 *             {
 *                 "TestAutomation",
 *             } },
 *         },
 *         DataServiceName = "DataTransformation",
 *         DataSinkId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestAzureStorage1",
 *         DataSourceId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestStorSimpleSource1",
 *         JobDefinitionName = "jobdeffromtestcode1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         RunLocation = AzureNative.HybridData.RunLocation.Westus,
 *         State = AzureNative.HybridData.State.Enabled,
 *         UserConfirmation = AzureNative.HybridData.UserConfirmation.Required,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybriddata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybriddata.NewJobDefinition(ctx, "jobDefinition", &hybriddata.JobDefinitionArgs{
 * 			DataManagerName: pulumi.String("TestAzureSDKOperations"),
 * 			DataServiceInput: pulumi.Any{
 * 				AzureStorageType: "Blob",
 * 				BackupChoice:     "UseExistingLatest",
 * 				ContainerName:    "containerfromtest",
 * 				DeviceName:       "8600-SHG0997877L71FC",
 * 				FileNameFilter:   "*",
 * 				IsDirectoryMode:  false,
 * 				RootDirectories: []string{
 * 					"\\",
 * 				},
 * 				VolumeNames: []string{
 * 					"TestAutomation",
 * 				},
 * 			},
 * 			DataServiceName:   pulumi.String("DataTransformation"),
 * 			DataSinkId:        pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestAzureStorage1"),
 * 			DataSourceId:      pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestStorSimpleSource1"),
 * 			JobDefinitionName: pulumi.String("jobdeffromtestcode1"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			RunLocation:       hybriddata.RunLocationWestus,
 * 			State:             hybriddata.StateEnabled,
 * 			UserConfirmation:  hybriddata.UserConfirmationRequired,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybriddata.JobDefinition;
 * import com.pulumi.azurenative.hybriddata.JobDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobDefinition = new JobDefinition("jobDefinition", JobDefinitionArgs.builder()
 *             .dataManagerName("TestAzureSDKOperations")
 *             .dataServiceInput(Map.ofEntries(
 *                 Map.entry("AzureStorageType", "Blob"),
 *                 Map.entry("BackupChoice", "UseExistingLatest"),
 *                 Map.entry("ContainerName", "containerfromtest"),
 *                 Map.entry("DeviceName", "8600-SHG0997877L71FC"),
 *                 Map.entry("FileNameFilter", "*"),
 *                 Map.entry("IsDirectoryMode", false),
 *                 Map.entry("RootDirectories", "\\"),
 *                 Map.entry("VolumeNames", "TestAutomation")
 *             ))
 *             .dataServiceName("DataTransformation")
 *             .dataSinkId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestAzureStorage1")
 *             .dataSourceId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestStorSimpleSource1")
 *             .jobDefinitionName("jobdeffromtestcode1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .runLocation("westus")
 *             .state("Enabled")
 *             .userConfirmation("Required")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybriddata:JobDefinition jobdeffromtestcode1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridData/dataManagers/{dataManagerName}/dataServices/{dataServiceName}/jobDefinitions/{jobDefinitionName}
 * ```
 * @property customerSecrets List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
 * @property dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property dataServiceInput A generic json used differently by each data service type.
 * @property dataServiceName The data service type of the job definition.
 * @property dataSinkId Data Sink Id associated to the job definition.
 * @property dataSourceId Data Source Id associated to the job definition.
 * @property jobDefinitionName The job definition name to be created or updated.
 * @property lastModifiedTime Last modified time of the job definition.
 * @property resourceGroupName The Resource Group Name
 * @property runLocation This is the preferred geo location for the job to run.
 * @property schedules Schedule for running the job definition
 * @property state State of the job definition.
 * @property userConfirmation Enum to detect if user confirmation is required. If not passed will default to NotRequired.
 */
public data class JobDefinitionArgs(
    public val customerSecrets: Output<List<CustomerSecretArgs>>? = null,
    public val dataManagerName: Output<String>? = null,
    public val dataServiceInput: Output<Any>? = null,
    public val dataServiceName: Output<String>? = null,
    public val dataSinkId: Output<String>? = null,
    public val dataSourceId: Output<String>? = null,
    public val jobDefinitionName: Output<String>? = null,
    public val lastModifiedTime: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runLocation: Output<RunLocation>? = null,
    public val schedules: Output<List<ScheduleArgs>>? = null,
    public val state: Output<State>? = null,
    public val userConfirmation: Output<UserConfirmation>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.JobDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.JobDefinitionArgs =
        com.pulumi.azurenative.hybriddata.JobDefinitionArgs.builder()
            .customerSecrets(
                customerSecrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataManagerName(dataManagerName?.applyValue({ args0 -> args0 }))
            .dataServiceInput(dataServiceInput?.applyValue({ args0 -> args0 }))
            .dataServiceName(dataServiceName?.applyValue({ args0 -> args0 }))
            .dataSinkId(dataSinkId?.applyValue({ args0 -> args0 }))
            .dataSourceId(dataSourceId?.applyValue({ args0 -> args0 }))
            .jobDefinitionName(jobDefinitionName?.applyValue({ args0 -> args0 }))
            .lastModifiedTime(lastModifiedTime?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runLocation(runLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedules(
                schedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userConfirmation(
                userConfirmation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [JobDefinitionArgs].
 */
@PulumiTagMarker
public class JobDefinitionArgsBuilder internal constructor() {
    private var customerSecrets: Output<List<CustomerSecretArgs>>? = null

    private var dataManagerName: Output<String>? = null

    private var dataServiceInput: Output<Any>? = null

    private var dataServiceName: Output<String>? = null

    private var dataSinkId: Output<String>? = null

    private var dataSourceId: Output<String>? = null

    private var jobDefinitionName: Output<String>? = null

    private var lastModifiedTime: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var runLocation: Output<RunLocation>? = null

    private var schedules: Output<List<ScheduleArgs>>? = null

    private var state: Output<State>? = null

    private var userConfirmation: Output<UserConfirmation>? = null

    /**
     * @param value List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("orehffksvoepivvy")
    public suspend fun customerSecrets(`value`: Output<List<CustomerSecretArgs>>) {
        this.customerSecrets = value
    }

    @JvmName("frevteevgfnotkbe")
    public suspend fun customerSecrets(vararg values: Output<CustomerSecretArgs>) {
        this.customerSecrets = Output.all(values.asList())
    }

    /**
     * @param values List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("uegejyvqhelnxion")
    public suspend fun customerSecrets(values: List<Output<CustomerSecretArgs>>) {
        this.customerSecrets = Output.all(values)
    }

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("gthyodslxuhwlbbc")
    public suspend fun dataManagerName(`value`: Output<String>) {
        this.dataManagerName = value
    }

    /**
     * @param value A generic json used differently by each data service type.
     */
    @JvmName("aaxkqyehogdxmeav")
    public suspend fun dataServiceInput(`value`: Output<Any>) {
        this.dataServiceInput = value
    }

    /**
     * @param value The data service type of the job definition.
     */
    @JvmName("ijxkdxejuplywpya")
    public suspend fun dataServiceName(`value`: Output<String>) {
        this.dataServiceName = value
    }

    /**
     * @param value Data Sink Id associated to the job definition.
     */
    @JvmName("nwudsqbmvqsbdyef")
    public suspend fun dataSinkId(`value`: Output<String>) {
        this.dataSinkId = value
    }

    /**
     * @param value Data Source Id associated to the job definition.
     */
    @JvmName("mnidutkmmcpgicss")
    public suspend fun dataSourceId(`value`: Output<String>) {
        this.dataSourceId = value
    }

    /**
     * @param value The job definition name to be created or updated.
     */
    @JvmName("tranlgrovqtejyge")
    public suspend fun jobDefinitionName(`value`: Output<String>) {
        this.jobDefinitionName = value
    }

    /**
     * @param value Last modified time of the job definition.
     */
    @JvmName("mbbewnkjjlalqwtd")
    public suspend fun lastModifiedTime(`value`: Output<String>) {
        this.lastModifiedTime = value
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("hvgbnegurucaqfof")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value This is the preferred geo location for the job to run.
     */
    @JvmName("dueitmiqlbrmwrmm")
    public suspend fun runLocation(`value`: Output<RunLocation>) {
        this.runLocation = value
    }

    /**
     * @param value Schedule for running the job definition
     */
    @JvmName("rqaachhtscmxuxlv")
    public suspend fun schedules(`value`: Output<List<ScheduleArgs>>) {
        this.schedules = value
    }

    @JvmName("ncvagcvyabiuhjut")
    public suspend fun schedules(vararg values: Output<ScheduleArgs>) {
        this.schedules = Output.all(values.asList())
    }

    /**
     * @param values Schedule for running the job definition
     */
    @JvmName("kqxeykifkccfvkxl")
    public suspend fun schedules(values: List<Output<ScheduleArgs>>) {
        this.schedules = Output.all(values)
    }

    /**
     * @param value State of the job definition.
     */
    @JvmName("yujrqwvecxycxfvs")
    public suspend fun state(`value`: Output<State>) {
        this.state = value
    }

    /**
     * @param value Enum to detect if user confirmation is required. If not passed will default to NotRequired.
     */
    @JvmName("uvokldjywibkrftf")
    public suspend fun userConfirmation(`value`: Output<UserConfirmation>) {
        this.userConfirmation = value
    }

    /**
     * @param value List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("hcsiyvwnufovlhes")
    public suspend fun customerSecrets(`value`: List<CustomerSecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerSecrets = mapped
    }

    /**
     * @param argument List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("lpcomgahomehhrth")
    public suspend fun customerSecrets(argument: List<suspend CustomerSecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomerSecretArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customerSecrets = mapped
    }

    /**
     * @param argument List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("wdpdahiqrcxnmajr")
    public suspend fun customerSecrets(
        vararg
        argument: suspend CustomerSecretArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomerSecretArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customerSecrets = mapped
    }

    /**
     * @param argument List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("wbbxdwplvphlqcjq")
    public suspend fun customerSecrets(argument: suspend CustomerSecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomerSecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customerSecrets = mapped
    }

    /**
     * @param values List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    @JvmName("mqdspmfjhwwxyymq")
    public suspend fun customerSecrets(vararg values: CustomerSecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerSecrets = mapped
    }

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("spijkxpggplwowkm")
    public suspend fun dataManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataManagerName = mapped
    }

    /**
     * @param value A generic json used differently by each data service type.
     */
    @JvmName("apkjgmwdwgmsprcn")
    public suspend fun dataServiceInput(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataServiceInput = mapped
    }

    /**
     * @param value The data service type of the job definition.
     */
    @JvmName("dfhykwrhblabukbe")
    public suspend fun dataServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataServiceName = mapped
    }

    /**
     * @param value Data Sink Id associated to the job definition.
     */
    @JvmName("pqoshvaroyuwlkgu")
    public suspend fun dataSinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSinkId = mapped
    }

    /**
     * @param value Data Source Id associated to the job definition.
     */
    @JvmName("ylwsxyelbfpvobxp")
    public suspend fun dataSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceId = mapped
    }

    /**
     * @param value The job definition name to be created or updated.
     */
    @JvmName("slpxauckiburadrj")
    public suspend fun jobDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobDefinitionName = mapped
    }

    /**
     * @param value Last modified time of the job definition.
     */
    @JvmName("ujemjuufitbkpamn")
    public suspend fun lastModifiedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedTime = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("hvqpwfyuwqpdwesb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value This is the preferred geo location for the job to run.
     */
    @JvmName("culsyhtycjcwjqig")
    public suspend fun runLocation(`value`: RunLocation?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runLocation = mapped
    }

    /**
     * @param value Schedule for running the job definition
     */
    @JvmName("ceajutaixjmxrwhj")
    public suspend fun schedules(`value`: List<ScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param argument Schedule for running the job definition
     */
    @JvmName("grrwqgusdlsoymrf")
    public suspend fun schedules(argument: List<suspend ScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ScheduleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument Schedule for running the job definition
     */
    @JvmName("hutsiwtdbojlrbxg")
    public suspend fun schedules(vararg argument: suspend ScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ScheduleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument Schedule for running the job definition
     */
    @JvmName("ykwduiwguimmdgos")
    public suspend fun schedules(argument: suspend ScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScheduleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param values Schedule for running the job definition
     */
    @JvmName("vmbgvjjktdyyulnf")
    public suspend fun schedules(vararg values: ScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param value State of the job definition.
     */
    @JvmName("nxbxmwncwibmpxuj")
    public suspend fun state(`value`: State?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Enum to detect if user confirmation is required. If not passed will default to NotRequired.
     */
    @JvmName("qlpsmsagfsvopesb")
    public suspend fun userConfirmation(`value`: UserConfirmation?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userConfirmation = mapped
    }

    internal fun build(): JobDefinitionArgs = JobDefinitionArgs(
        customerSecrets = customerSecrets,
        dataManagerName = dataManagerName,
        dataServiceInput = dataServiceInput,
        dataServiceName = dataServiceName,
        dataSinkId = dataSinkId,
        dataSourceId = dataSourceId,
        jobDefinitionName = jobDefinitionName,
        lastModifiedTime = lastModifiedTime,
        resourceGroupName = resourceGroupName,
        runLocation = runLocation,
        schedules = schedules,
        state = state,
        userConfirmation = userConfirmation,
    )
}
