@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ConfigurationValueWithSecretsArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ConfigurationValueWithoutSecretsArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Hybrid configuration group value resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update configuration group value
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationGroupValue = new AzureNative.HybridNetwork.ConfigurationGroupValue("configurationGroupValue", new()
 *     {
 *         ConfigurationGroupValueName = "testConfigurationGroupValue",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ConfigurationValueWithoutSecretsArgs
 *         {
 *             ConfigurationGroupSchemaResourceReference = new AzureNative.HybridNetwork.Inputs.OpenDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName",
 *                 IdType = "Open",
 *             },
 *             ConfigurationType = "Open",
 *             ConfigurationValue = "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewConfigurationGroupValue(ctx, "configurationGroupValue", &hybridnetwork.ConfigurationGroupValueArgs{
 * 			ConfigurationGroupValueName: pulumi.String("testConfigurationGroupValue"),
 * 			Location:                    pulumi.String("eastus"),
 * 			Properties: hybridnetwork.ConfigurationValueWithoutSecrets{
 * 				ConfigurationGroupSchemaResourceReference: hybridnetwork.OpenDeploymentResourceReference{
 * 					Id:     "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName",
 * 					IdType: "Open",
 * 				},
 * 				ConfigurationType:  "Open",
 * 				ConfigurationValue: "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}",
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValue;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationGroupValue = new ConfigurationGroupValue("configurationGroupValue", ConfigurationGroupValueArgs.builder()
 *             .configurationGroupValueName("testConfigurationGroupValue")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configurationGroupSchemaResourceReference", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName"),
 *                     Map.entry("idType", "Open")
 *                 )),
 *                 Map.entry("configurationType", "Open"),
 *                 Map.entry("configurationValue", "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update configuration group value with secrets
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationGroupValue = new AzureNative.HybridNetwork.ConfigurationGroupValue("configurationGroupValue", new()
 *     {
 *         ConfigurationGroupValueName = "testConfigurationGroupValue",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ConfigurationValueWithSecretsArgs
 *         {
 *             ConfigurationGroupSchemaResourceReference = new AzureNative.HybridNetwork.Inputs.OpenDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName",
 *                 IdType = "Open",
 *             },
 *             ConfigurationType = "Secret",
 *             SecretConfigurationValue = "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewConfigurationGroupValue(ctx, "configurationGroupValue", &hybridnetwork.ConfigurationGroupValueArgs{
 * 			ConfigurationGroupValueName: pulumi.String("testConfigurationGroupValue"),
 * 			Location:                    pulumi.String("eastus"),
 * 			Properties: hybridnetwork.ConfigurationValueWithSecrets{
 * 				ConfigurationGroupSchemaResourceReference: hybridnetwork.OpenDeploymentResourceReference{
 * 					Id:     "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName",
 * 					IdType: "Open",
 * 				},
 * 				ConfigurationType:        "Secret",
 * 				SecretConfigurationValue: "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}",
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValue;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationGroupValue = new ConfigurationGroupValue("configurationGroupValue", ConfigurationGroupValueArgs.builder()
 *             .configurationGroupValueName("testConfigurationGroupValue")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configurationGroupSchemaResourceReference", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName"),
 *                     Map.entry("idType", "Open")
 *                 )),
 *                 Map.entry("configurationType", "Secret"),
 *                 Map.entry("secretConfigurationValue", "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update first party configuration group value
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationGroupValue = new AzureNative.HybridNetwork.ConfigurationGroupValue("configurationGroupValue", new()
 *     {
 *         ConfigurationGroupValueName = "testConfigurationGroupValue",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ConfigurationValueWithoutSecretsArgs
 *         {
 *             ConfigurationGroupSchemaResourceReference = new AzureNative.HybridNetwork.Inputs.SecretDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName",
 *                 IdType = "Secret",
 *             },
 *             ConfigurationType = "Open",
 *             ConfigurationValue = "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewConfigurationGroupValue(ctx, "configurationGroupValue", &hybridnetwork.ConfigurationGroupValueArgs{
 * 			ConfigurationGroupValueName: pulumi.String("testConfigurationGroupValue"),
 * 			Location:                    pulumi.String("eastus"),
 * 			Properties: hybridnetwork.ConfigurationValueWithoutSecrets{
 * 				ConfigurationGroupSchemaResourceReference: hybridnetwork.SecretDeploymentResourceReference{
 * 					Id:     "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName",
 * 					IdType: "Secret",
 * 				},
 * 				ConfigurationType:  "Open",
 * 				ConfigurationValue: "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}",
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValue;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationGroupValue = new ConfigurationGroupValue("configurationGroupValue", ConfigurationGroupValueArgs.builder()
 *             .configurationGroupValueName("testConfigurationGroupValue")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configurationGroupSchemaResourceReference", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourcegroups/testRG/providers/microsoft.hybridnetwork/publishers/testPublisher/configurationGroupSchemas/testConfigurationGroupSchemaName"),
 *                     Map.entry("idType", "Secret")
 *                 )),
 *                 Map.entry("configurationType", "Open"),
 *                 Map.entry("configurationValue", "{\"interconnect-groups\":{\"stripe-one\":{\"name\":\"Stripe one\",\"international-interconnects\":[\"france\",\"germany\"],\"domestic-interconnects\":[\"birmingham\",\"edinburgh\"]},\"stripe-two\":{\"name\":\"Stripe two\",\"international-interconnects\":[\"germany\",\"italy\"],\"domestic-interconnects\":[\"edinburgh\",\"london\"]}},\"interconnect-group-assignments\":{\"ssc-one\":{\"ssc\":\"SSC 1\",\"interconnects\":\"stripe-one\"},\"ssc-two\":{\"ssc\":\"SSC 2\",\"interconnects\":\"stripe-two\"}}}")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ConfigurationGroupValue testConfigurationGroupValue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}
 * ```
 * @property configurationGroupValueName The name of the configuration group value.
 * @property location The geo-location where the resource lives
 * @property properties Hybrid configuration group value properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ConfigurationGroupValueArgs(
    public val configurationGroupValueName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties:
    Output<Either<ConfigurationValueWithSecretsArgs, ConfigurationValueWithoutSecretsArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs =
        com.pulumi.azurenative.hybridnetwork.ConfigurationGroupValueArgs.builder()
            .configurationGroupValueName(configurationGroupValueName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationGroupValueArgs].
 */
@PulumiTagMarker
public class ConfigurationGroupValueArgsBuilder internal constructor() {
    private var configurationGroupValueName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties:
        Output<Either<ConfigurationValueWithSecretsArgs, ConfigurationValueWithoutSecretsArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the configuration group value.
     */
    @JvmName("slwawcslrqvyrsnr")
    public suspend fun configurationGroupValueName(`value`: Output<String>) {
        this.configurationGroupValueName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("birjsnlgqinaauds")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Hybrid configuration group value properties.
     */
    @JvmName("pqskqwvduodkxiqb")
    public suspend
    fun properties(`value`: Output<Either<ConfigurationValueWithSecretsArgs, ConfigurationValueWithoutSecretsArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wcfgvogecxlmqgda")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mrnbjlmmmxlndevg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the configuration group value.
     */
    @JvmName("kqrjykjygbcxkbac")
    public suspend fun configurationGroupValueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationGroupValueName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jknvotqobfgyhrcy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Hybrid configuration group value properties.
     */
    @JvmName("yityydigovwluvgv")
    public suspend
    fun properties(`value`: Either<ConfigurationValueWithSecretsArgs, ConfigurationValueWithoutSecretsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Hybrid configuration group value properties.
     */
    @JvmName("ibxgbscakvfjvcna")
    public fun properties(`value`: ConfigurationValueWithSecretsArgs) {
        val toBeMapped = Either.ofLeft<ConfigurationValueWithSecretsArgs,
            ConfigurationValueWithoutSecretsArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Hybrid configuration group value properties.
     */
    @JvmName("xwpujtqmahxhuqrk")
    public fun properties(`value`: ConfigurationValueWithoutSecretsArgs) {
        val toBeMapped = Either.ofRight<ConfigurationValueWithSecretsArgs,
            ConfigurationValueWithoutSecretsArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bwwikfmmrffivrho")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hgvtrrvndrtxnakw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("swjmlmjosrcsyxdt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationGroupValueArgs = ConfigurationGroupValueArgs(
        configurationGroupValueName = configurationGroupValueName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
