@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ContainerizedNetworkFunctionDefinitionVersionResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkFunctionDefinitionVersion].
 */
@PulumiTagMarker
public class NetworkFunctionDefinitionVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkFunctionDefinitionVersionArgs = NetworkFunctionDefinitionVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkFunctionDefinitionVersionArgsBuilder.() -> Unit) {
        val builder = NetworkFunctionDefinitionVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkFunctionDefinitionVersion {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkFunctionDefinitionVersion(builtJavaResource)
    }
}

/**
 * Network function definition version.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update a network function definition version resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionVersion = new AzureNative.HybridNetwork.NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         NetworkFunctionDefinitionVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ContainerizedNetworkFunctionDefinitionVersionArgs
 *         {
 *             DeployParameters = "{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}",
 *             NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesNetworkFunctionTemplateArgs
 *             {
 *                 NetworkFunctionApplications = new[]
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesHelmApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore",
 *                             },
 *                             HelmArtifactProfile = new AzureNative.HybridNetwork.Inputs.HelmArtifactProfileArgs
 *                             {
 *                                 HelmPackageName = "fed-rbac",
 *                                 HelmPackageVersionRange = "~2.1.3",
 *                                 ImagePullSecretsValuesPaths = new[]
 *                                 {
 *                                     "global.imagePullSecrets",
 *                                 },
 *                                 RegistryValuesPaths = new[]
 *                                 {
 *                                     "global.registry.docker.repoPath",
 *                                 },
 *                             },
 *                         },
 *                         ArtifactType = "HelmPackage",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new() { },
 *                             UninstallDependsOn = new() { },
 *                             UpdateDependsOn = new() { },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = "Enabled",
 *                             HelmMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.HelmMappingRuleProfileArgs
 *                             {
 *                                 HelmPackageVersion = "2.1.3",
 *                                 Options = new AzureNative.HybridNetwork.Inputs.HelmMappingRuleProfileOptionsArgs
 *                                 {
 *                                     InstallOptions = new AzureNative.HybridNetwork.Inputs.HelmInstallOptionsArgs
 *                                     {
 *                                         Atomic = "true",
 *                                         Timeout = "30",
 *                                         Wait = "waitValue",
 *                                     },
 *                                     UpgradeOptions = new AzureNative.HybridNetwork.Inputs.HelmUpgradeOptionsArgs
 *                                     {
 *                                         Atomic = "true",
 *                                         Timeout = "30",
 *                                         Wait = "waitValue",
 *                                     },
 *                                 },
 *                                 ReleaseName = "{deployParameters.releaseName}",
 *                                 ReleaseNamespace = "{deployParameters.namesapce}",
 *                                 Values = "",
 *                             },
 *                         },
 *                         Name = "fedrbac",
 *                     },
 *                 },
 *                 NfviType = "AzureArcKubernetes",
 *             },
 *             NetworkFunctionType = "ContainerizedNetworkFunction",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionVersion(ctx, "networkFunctionDefinitionVersion", &hybridnetwork.NetworkFunctionDefinitionVersionArgs{
 * 			Location:                             pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName:   pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			NetworkFunctionDefinitionVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
 * 				DeployParameters: "{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}",
 * 				NetworkFunctionTemplate: hybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
 * 					NetworkFunctionApplications: []hybridnetwork.AzureArcKubernetesHelmApplication{
 * 						{
 * 							ArtifactProfile: {
 * 								ArtifactStore: {
 * 									Id: "/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore",
 * 								},
 * 								HelmArtifactProfile: {
 * 									HelmPackageName:         "fed-rbac",
 * 									HelmPackageVersionRange: "~2.1.3",
 * 									ImagePullSecretsValuesPaths: []string{
 * 										"global.imagePullSecrets",
 * 									},
 * 									RegistryValuesPaths: []string{
 * 										"global.registry.docker.repoPath",
 * 									},
 * 								},
 * 							},
 * 							ArtifactType: "HelmPackage",
 * 							DependsOnProfile: {
 * 								InstallDependsOn:   []interface{}{},
 * 								UninstallDependsOn: []interface{}{},
 * 								UpdateDependsOn:    []interface{}{},
 * 							},
 * 							DeployParametersMappingRuleProfile: {
 * 								ApplicationEnablement: "Enabled",
 * 								HelmMappingRuleProfile: {
 * 									HelmPackageVersion: "2.1.3",
 * 									Options: {
 * 										InstallOptions: {
 * 											Atomic:  "true",
 * 											Timeout: "30",
 * 											Wait:    "waitValue",
 * 										},
 * 										UpgradeOptions: {
 * 											Atomic:  "true",
 * 											Timeout: "30",
 * 											Wait:    "waitValue",
 * 										},
 * 									},
 * 									ReleaseName:      "{deployParameters.releaseName}",
 * 									ReleaseNamespace: "{deployParameters.namesapce}",
 * 									Values:           "",
 * 								},
 * 							},
 * 							Name: "fedrbac",
 * 						},
 * 					},
 * 					NfviType: "AzureArcKubernetes",
 * 				},
 * 				NetworkFunctionType: "ContainerizedNetworkFunction",
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionVersion = new NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", NetworkFunctionDefinitionVersionArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .networkFunctionDefinitionVersionName("1.0.0")
 *             .properties(Map.ofEntries(
 *                 Map.entry("deployParameters", "{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}"),
 *                 Map.entry("networkFunctionTemplate", Map.ofEntries(
 *                     Map.entry("networkFunctionApplications", Map.ofEntries(
 *                         Map.entry("artifactProfile", Map.ofEntries(
 *                             Map.entry("artifactStore", Map.of("id", "/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore")),
 *                             Map.entry("helmArtifactProfile", Map.ofEntries(
 *                                 Map.entry("helmPackageName", "fed-rbac"),
 *                                 Map.entry("helmPackageVersionRange", "~2.1.3"),
 *                                 Map.entry("imagePullSecretsValuesPaths", "global.imagePullSecrets"),
 *                                 Map.entry("registryValuesPaths", "global.registry.docker.repoPath")
 *                             ))
 *                         )),
 *                         Map.entry("artifactType", "HelmPackage"),
 *                         Map.entry("dependsOnProfile", Map.ofEntries(
 *                             Map.entry("installDependsOn", ),
 *                             Map.entry("uninstallDependsOn", ),
 *                             Map.entry("updateDependsOn", )
 *                         )),
 *                         Map.entry("deployParametersMappingRuleProfile", Map.ofEntries(
 *                             Map.entry("applicationEnablement", "Enabled"),
 *                             Map.entry("helmMappingRuleProfile", Map.ofEntries(
 *                                 Map.entry("helmPackageVersion", "2.1.3"),
 *                                 Map.entry("options", Map.ofEntries(
 *                                     Map.entry("installOptions", Map.ofEntries(
 *                                         Map.entry("atomic", "true"),
 *                                         Map.entry("timeout", "30"),
 *                                         Map.entry("wait", "waitValue")
 *                                     )),
 *                                     Map.entry("upgradeOptions", Map.ofEntries(
 *                                         Map.entry("atomic", "true"),
 *                                         Map.entry("timeout", "30"),
 *                                         Map.entry("wait", "waitValue")
 *                                     ))
 *                                 )),
 *                                 Map.entry("releaseName", "{deployParameters.releaseName}"),
 *                                 Map.entry("releaseNamespace", "{deployParameters.namesapce}"),
 *                                 Map.entry("values", "")
 *                             ))
 *                         )),
 *                         Map.entry("name", "fedrbac")
 *                     )),
 *                     Map.entry("nfviType", "AzureArcKubernetes")
 *                 )),
 *                 Map.entry("networkFunctionType", "ContainerizedNetworkFunction")
 *             ))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a network function definition version resource for AzureCore VNF
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionVersion = new AzureNative.HybridNetwork.NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         NetworkFunctionDefinitionVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs
 *         {
 *             DeployParameters = "{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 *             Description = "test NFDV for AzureCore",
 *             NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.AzureCoreNetworkFunctionTemplateArgs
 *             {
 *                 NetworkFunctionApplications =
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.AzureCoreNetworkFunctionVhdApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreVhdImageArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             VhdArtifactProfile = new AzureNative.HybridNetwork.Inputs.VhdImageArtifactProfileArgs
 *                             {
 *                                 VhdName = "test-image",
 *                                 VhdVersion = "1-0-0",
 *                             },
 *                         },
 *                         ArtifactType = "VhdImageFile",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new() { },
 *                             UninstallDependsOn = new() { },
 *                             UpdateDependsOn = new() { },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreVhdImageDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = "Unknown",
 *                             VhdImageMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.VhdImageMappingRuleProfileArgs
 *                             {
 *                                 UserConfiguration = "",
 *                             },
 *                         },
 *                         Name = "testImageRole",
 *                     },
 *                     new AzureNative.HybridNetwork.Inputs.AzureCoreNetworkFunctionArmTemplateApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreArmTemplateArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             TemplateArtifactProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateArtifactProfileArgs
 *                             {
 *                                 TemplateName = "test-template",
 *                                 TemplateVersion = "1.0.0",
 *                             },
 *                         },
 *                         ArtifactType = "ArmTemplate",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UninstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UpdateDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreArmTemplateDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = "Unknown",
 *                             TemplateMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateMappingRuleProfileArgs
 *                             {
 *                                 TemplateParameters = "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 *                             },
 *                         },
 *                         Name = "testTemplateRole",
 *                     },
 *                 },
 *                 NfviType = "AzureCore",
 *             },
 *             NetworkFunctionType = "VirtualNetworkFunction",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionVersion(ctx, "networkFunctionDefinitionVersion", &hybridnetwork.NetworkFunctionDefinitionVersionArgs{
 * 			Location:                             pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName:   pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			NetworkFunctionDefinitionVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.VirtualNetworkFunctionNetworkFunctionDefinitionVersion{
 * 				DeployParameters: "{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 * 				Description:      "test NFDV for AzureCore",
 * 				NetworkFunctionTemplate: hybridnetwork.AzureCoreNetworkFunctionTemplate{
 * 					NetworkFunctionApplications: []interface{}{
 * 						hybridnetwork.AzureCoreNetworkFunctionVhdApplication{
 * 							ArtifactProfile: hybridnetwork.AzureCoreVhdImageArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								VhdArtifactProfile: hybridnetwork.VhdImageArtifactProfile{
 * 									VhdName:    "test-image",
 * 									VhdVersion: "1-0-0",
 * 								},
 * 							},
 * 							ArtifactType: "VhdImageFile",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn:   []interface{}{},
 * 								UninstallDependsOn: []interface{}{},
 * 								UpdateDependsOn:    []interface{}{},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureCoreVhdImageDeployMappingRuleProfile{
 * 								ApplicationEnablement: "Unknown",
 * 								VhdImageMappingRuleProfile: hybridnetwork.VhdImageMappingRuleProfile{
 * 									UserConfiguration: "",
 * 								},
 * 							},
 * 							Name: "testImageRole",
 * 						},
 * 						hybridnetwork.AzureCoreNetworkFunctionArmTemplateApplication{
 * 							ArtifactProfile: hybridnetwork.AzureCoreArmTemplateArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								TemplateArtifactProfile: hybridnetwork.ArmTemplateArtifactProfile{
 * 									TemplateName:    "test-template",
 * 									TemplateVersion: "1.0.0",
 * 								},
 * 							},
 * 							ArtifactType: "ArmTemplate",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UninstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UpdateDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureCoreArmTemplateDeployMappingRuleProfile{
 * 								ApplicationEnablement: "Unknown",
 * 								TemplateMappingRuleProfile: hybridnetwork.ArmTemplateMappingRuleProfile{
 * 									TemplateParameters: "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 * 								},
 * 							},
 * 							Name: "testTemplateRole",
 * 						},
 * 					},
 * 					NfviType: "AzureCore",
 * 				},
 * 				NetworkFunctionType: "VirtualNetworkFunction",
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionVersion = new NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", NetworkFunctionDefinitionVersionArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .networkFunctionDefinitionVersionName("1.0.0")
 *             .properties(Map.ofEntries(
 *                 Map.entry("deployParameters", "{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
 *                 Map.entry("description", "test NFDV for AzureCore"),
 *                 Map.entry("networkFunctionTemplate", Map.ofEntries(
 *                     Map.entry("networkFunctionApplications",
 *                         Map.ofEntries(
 *                             Map.entry("artifactProfile", Map.ofEntries(
 *                                 Map.entry("artifactStore", Map.of("id", "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")),
 *                                 Map.entry("vhdArtifactProfile", Map.ofEntries(
 *                                     Map.entry("vhdName", "test-image"),
 *                                     Map.entry("vhdVersion", "1-0-0")
 *                                 ))
 *                             )),
 *                             Map.entry("artifactType", "VhdImageFile"),
 *                             Map.entry("dependsOnProfile", Map.ofEntries(
 *                                 Map.entry("installDependsOn", ),
 *                                 Map.entry("uninstallDependsOn", ),
 *                                 Map.entry("updateDependsOn", )
 *                             )),
 *                             Map.entry("deployParametersMappingRuleProfile", Map.ofEntries(
 *                                 Map.entry("applicationEnablement", "Unknown"),
 *                                 Map.entry("vhdImageMappingRuleProfile", Map.of("userConfiguration", ""))
 *                             )),
 *                             Map.entry("name", "testImageRole")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("artifactProfile", Map.ofEntries(
 *                                 Map.entry("artifactStore", Map.of("id", "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")),
 *                                 Map.entry("templateArtifactProfile", Map.ofEntries(
 *                                     Map.entry("templateName", "test-template"),
 *                                     Map.entry("templateVersion", "1.0.0")
 *                                 ))
 *                             )),
 *                             Map.entry("artifactType", "ArmTemplate"),
 *                             Map.entry("dependsOnProfile", Map.ofEntries(
 *                                 Map.entry("installDependsOn", "testImageRole"),
 *                                 Map.entry("uninstallDependsOn", "testImageRole"),
 *                                 Map.entry("updateDependsOn", "testImageRole")
 *                             )),
 *                             Map.entry("deployParametersMappingRuleProfile", Map.ofEntries(
 *                                 Map.entry("applicationEnablement", "Unknown"),
 *                                 Map.entry("templateMappingRuleProfile", Map.of("templateParameters", "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"))
 *                             )),
 *                             Map.entry("name", "testTemplateRole")
 *                         )),
 *                     Map.entry("nfviType", "AzureCore")
 *                 )),
 *                 Map.entry("networkFunctionType", "VirtualNetworkFunction")
 *             ))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a network function definition version resource for AzureOperatorNexus VNF
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionVersion = new AzureNative.HybridNetwork.NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         NetworkFunctionDefinitionVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs
 *         {
 *             DeployParameters = "{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 *             Description = "test NFDV for AzureOperatorNexus",
 *             NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusNetworkFunctionTemplateArgs
 *             {
 *                 NetworkFunctionApplications =
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusNetworkFunctionImageApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusImageArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             ImageArtifactProfile = new AzureNative.HybridNetwork.Inputs.ImageArtifactProfileArgs
 *                             {
 *                                 ImageName = "test-image",
 *                                 ImageVersion = "1.0.0",
 *                             },
 *                         },
 *                         ArtifactType = "ImageFile",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new() { },
 *                             UninstallDependsOn = new() { },
 *                             UpdateDependsOn = new() { },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusImageDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = "Unknown",
 *                             ImageMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.ImageMappingRuleProfileArgs
 *                             {
 *                                 UserConfiguration = "",
 *                             },
 *                         },
 *                         Name = "testImageRole",
 *                     },
 *                     new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusArmTemplateArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             TemplateArtifactProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateArtifactProfileArgs
 *                             {
 *                                 TemplateName = "test-template",
 *                                 TemplateVersion = "1.0.0",
 *                             },
 *                         },
 *                         ArtifactType = "ArmTemplate",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UninstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UpdateDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = "Unknown",
 *                             TemplateMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateMappingRuleProfileArgs
 *                             {
 *                                 TemplateParameters = "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 *                             },
 *                         },
 *                         Name = "testTemplateRole",
 *                     },
 *                 },
 *                 NfviType = "AzureOperatorNexus",
 *             },
 *             NetworkFunctionType = "VirtualNetworkFunction",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionVersion(ctx, "networkFunctionDefinitionVersion", &hybridnetwork.NetworkFunctionDefinitionVersionArgs{
 * 			Location:                             pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName:   pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			NetworkFunctionDefinitionVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.VirtualNetworkFunctionNetworkFunctionDefinitionVersion{
 * 				DeployParameters: "{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 * 				Description:      "test NFDV for AzureOperatorNexus",
 * 				NetworkFunctionTemplate: hybridnetwork.AzureOperatorNexusNetworkFunctionTemplate{
 * 					NetworkFunctionApplications: []interface{}{
 * 						hybridnetwork.AzureOperatorNexusNetworkFunctionImageApplication{
 * 							ArtifactProfile: hybridnetwork.AzureOperatorNexusImageArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								ImageArtifactProfile: hybridnetwork.ImageArtifactProfile{
 * 									ImageName:    "test-image",
 * 									ImageVersion: "1.0.0",
 * 								},
 * 							},
 * 							ArtifactType: "ImageFile",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn:   []interface{}{},
 * 								UninstallDependsOn: []interface{}{},
 * 								UpdateDependsOn:    []interface{}{},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureOperatorNexusImageDeployMappingRuleProfile{
 * 								ApplicationEnablement: "Unknown",
 * 								ImageMappingRuleProfile: hybridnetwork.ImageMappingRuleProfile{
 * 									UserConfiguration: "",
 * 								},
 * 							},
 * 							Name: "testImageRole",
 * 						},
 * 						hybridnetwork.AzureOperatorNexusNetworkFunctionArmTemplateApplication{
 * 							ArtifactProfile: hybridnetwork.AzureOperatorNexusArmTemplateArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								TemplateArtifactProfile: hybridnetwork.ArmTemplateArtifactProfile{
 * 									TemplateName:    "test-template",
 * 									TemplateVersion: "1.0.0",
 * 								},
 * 							},
 * 							ArtifactType: "ArmTemplate",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UninstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UpdateDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureOperatorNexusArmTemplateDeployMappingRuleProfile{
 * 								ApplicationEnablement: "Unknown",
 * 								TemplateMappingRuleProfile: hybridnetwork.ArmTemplateMappingRuleProfile{
 * 									TemplateParameters: "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 * 								},
 * 							},
 * 							Name: "testTemplateRole",
 * 						},
 * 					},
 * 					NfviType: "AzureOperatorNexus",
 * 				},
 * 				NetworkFunctionType: "VirtualNetworkFunction",
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionVersion = new NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", NetworkFunctionDefinitionVersionArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .networkFunctionDefinitionVersionName("1.0.0")
 *             .properties(Map.ofEntries(
 *                 Map.entry("deployParameters", "{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
 *                 Map.entry("description", "test NFDV for AzureOperatorNexus"),
 *                 Map.entry("networkFunctionTemplate", Map.ofEntries(
 *                     Map.entry("networkFunctionApplications",
 *                         Map.ofEntries(
 *                             Map.entry("artifactProfile", Map.ofEntries(
 *                                 Map.entry("artifactStore", Map.of("id", "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")),
 *                                 Map.entry("imageArtifactProfile", Map.ofEntries(
 *                                     Map.entry("imageName", "test-image"),
 *                                     Map.entry("imageVersion", "1.0.0")
 *                                 ))
 *                             )),
 *                             Map.entry("artifactType", "ImageFile"),
 *                             Map.entry("dependsOnProfile", Map.ofEntries(
 *                                 Map.entry("installDependsOn", ),
 *                                 Map.entry("uninstallDependsOn", ),
 *                                 Map.entry("updateDependsOn", )
 *                             )),
 *                             Map.entry("deployParametersMappingRuleProfile", Map.ofEntries(
 *                                 Map.entry("applicationEnablement", "Unknown"),
 *                                 Map.entry("imageMappingRuleProfile", Map.of("userConfiguration", ""))
 *                             )),
 *                             Map.entry("name", "testImageRole")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("artifactProfile", Map.ofEntries(
 *                                 Map.entry("artifactStore", Map.of("id", "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")),
 *                                 Map.entry("templateArtifactProfile", Map.ofEntries(
 *                                     Map.entry("templateName", "test-template"),
 *                                     Map.entry("templateVersion", "1.0.0")
 *                                 ))
 *                             )),
 *                             Map.entry("artifactType", "ArmTemplate"),
 *                             Map.entry("dependsOnProfile", Map.ofEntries(
 *                                 Map.entry("installDependsOn", "testImageRole"),
 *                                 Map.entry("uninstallDependsOn", "testImageRole"),
 *                                 Map.entry("updateDependsOn", "testImageRole")
 *                             )),
 *                             Map.entry("deployParametersMappingRuleProfile", Map.ofEntries(
 *                                 Map.entry("applicationEnablement", "Unknown"),
 *                                 Map.entry("templateMappingRuleProfile", Map.of("templateParameters", "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"))
 *                             )),
 *                             Map.entry("name", "testTemplateRole")
 *                         )),
 *                     Map.entry("nfviType", "AzureOperatorNexus")
 *                 )),
 *                 Map.entry("networkFunctionType", "VirtualNetworkFunction")
 *             ))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkFunctionDefinitionVersion TestVersion /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkFunctionDefinitionGroups/{networkFunctionDefinitionGroupName}/networkFunctionDefinitionVersions/{networkFunctionDefinitionVersionName}
 * ```
 */
public class NetworkFunctionDefinitionVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion,
) : KotlinCustomResource(javaResource, NetworkFunctionDefinitionVersionMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network function definition version properties.
     */
    public val properties:
        Output<Either<ContainerizedNetworkFunctionDefinitionVersionResponse, VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ContainerizedNetworkFunctionDefinitionVersionResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkFunctionDefinitionVersionMapper :
    ResourceMapper<NetworkFunctionDefinitionVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion::class == javaResource::class

    override fun map(javaResource: Resource): NetworkFunctionDefinitionVersion =
        NetworkFunctionDefinitionVersion(
            javaResource as
                com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion,
        )
}

/**
 * @see [NetworkFunctionDefinitionVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkFunctionDefinitionVersion].
 */
public suspend fun networkFunctionDefinitionVersion(
    name: String,
    block: suspend NetworkFunctionDefinitionVersionResourceBuilder.() -> Unit,
):
    NetworkFunctionDefinitionVersion {
    val builder = NetworkFunctionDefinitionVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkFunctionDefinitionVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkFunctionDefinitionVersion(name: String): NetworkFunctionDefinitionVersion {
    val builder = NetworkFunctionDefinitionVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
