@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.SiteArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SitePropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SitePropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Site resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create network site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var site = new AzureNative.HybridNetwork.Site("site", new()
 *     {
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.SitePropertiesFormatArgs
 *         {
 *             Nfvis =
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.AzureCoreNFVIDetailsArgs
 *                 {
 *                     Location = "westUs2",
 *                     Name = "nfvi1",
 *                     NfviType = "AzureCore",
 *                 },
 *                 new AzureNative.HybridNetwork.Inputs.AzureArcK8sClusterNFVIDetailsArgs
 *                 {
 *                     CustomLocationReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation1",
 *                     },
 *                     Name = "nfvi2",
 *                     NfviType = "AzureArcKubernetes",
 *                 },
 *                 new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusClusterNFVIDetailsArgs
 *                 {
 *                     CustomLocationReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation2",
 *                     },
 *                     Name = "nfvi3",
 *                     NfviType = "AzureOperatorNexus",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteName = "testSite",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewSite(ctx, "site", &hybridnetwork.SiteArgs{
 * 			Location: pulumi.String("westUs2"),
 * 			Properties: hybridnetwork.SitePropertiesFormatResponse{
 * 				Nfvis: pulumi.Array{
 * 					hybridnetwork.AzureCoreNFVIDetails{
 * 						Location: "westUs2",
 * 						Name:     "nfvi1",
 * 						NfviType: "AzureCore",
 * 					},
 * 					hybridnetwork.AzureArcK8sClusterNFVIDetails{
 * 						CustomLocationReference: hybridnetwork.ReferencedResource{
 * 							Id: "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation1",
 * 						},
 * 						Name:     "nfvi2",
 * 						NfviType: "AzureArcKubernetes",
 * 					},
 * 					hybridnetwork.AzureOperatorNexusClusterNFVIDetails{
 * 						CustomLocationReference: hybridnetwork.ReferencedResource{
 * 							Id: "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation2",
 * 						},
 * 						Name:     "nfvi3",
 * 						NfviType: "AzureOperatorNexus",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SiteName:          pulumi.String("testSite"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.Site;
 * import com.pulumi.azurenative.hybridnetwork.SiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var site = new Site("site", SiteArgs.builder()
 *             .location("westUs2")
 *             .properties(Map.of("nfvis",
 *                 Map.ofEntries(
 *                     Map.entry("location", "westUs2"),
 *                     Map.entry("name", "nfvi1"),
 *                     Map.entry("nfviType", "AzureCore")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("customLocationReference", Map.of("id", "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation1")),
 *                     Map.entry("name", "nfvi2"),
 *                     Map.entry("nfviType", "AzureArcKubernetes")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("customLocationReference", Map.of("id", "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation2")),
 *                     Map.entry("name", "nfvi3"),
 *                     Map.entry("nfviType", "AzureOperatorNexus")
 *                 )))
 *             .resourceGroupName("rg1")
 *             .siteName("testSite")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:Site testSite /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/sites/{siteName}
 * ```
 * @property location The geo-location where the resource lives
 * @property properties Site properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The name of the network service site.
 * @property tags Resource tags.
 */
public data class SiteArgs(
    public val location: Output<String>? = null,
    public val properties: Output<SitePropertiesFormatArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.SiteArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.SiteArgs =
        com.pulumi.azurenative.hybridnetwork.SiteArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SiteArgs].
 */
@PulumiTagMarker
public class SiteArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<SitePropertiesFormatArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rartshajnqwdmyqr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Site properties.
     */
    @JvmName("yvvlvjwquoxnwylk")
    public suspend fun properties(`value`: Output<SitePropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dmvixnneuvacumyx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network service site.
     */
    @JvmName("uywetesfwlylkukf")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("swlfjncmerugvkhk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kksguhoublnsvdpw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Site properties.
     */
    @JvmName("geegombvevrlhcju")
    public suspend fun properties(`value`: SitePropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Site properties.
     */
    @JvmName("pjcgepfytyuehiov")
    public suspend fun properties(argument: suspend SitePropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = SitePropertiesFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iguravfsbddbmbcf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network service site.
     */
    @JvmName("cymvklsiayfqdbyr")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xnywvvopdgqqwyad")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("atojyrvgmsimeegr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SiteArgs = SiteArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        tags = tags,
    )
}
