@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Vendor].
 */
@PulumiTagMarker
public class VendorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VendorArgs = VendorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VendorArgsBuilder.() -> Unit) {
        val builder = VendorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Vendor {
        val builtJavaResource = com.pulumi.azurenative.hybridnetwork.Vendor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vendor(builtJavaResource)
    }
}

/**
 * Vendor resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### Create or update Vendor resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vendor = new AzureNative.HybridNetwork.Vendor("vendor", new()
 *     {
 *         VendorName = "TestVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewVendor(ctx, "vendor", &hybridnetwork.VendorArgs{
 * 			VendorName: pulumi.String("TestVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.Vendor;
 * import com.pulumi.azurenative.hybridnetwork.VendorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vendor = new Vendor("vendor", VendorArgs.builder()
 *             .vendorName("TestVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:Vendor TestVendor /subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/vendors/{vendorName}
 * ```
 */
public class Vendor internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.Vendor,
) : KotlinCustomResource(javaResource, VendorMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the vendor resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A list of IDs of the vendor skus offered by the vendor.
     */
    public val skus: Output<List<SubResourceResponse>>
        get() = javaResource.skus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            })
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VendorMapper : ResourceMapper<Vendor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.Vendor::class == javaResource::class

    override fun map(javaResource: Resource): Vendor = Vendor(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.Vendor,
    )
}

/**
 * @see [Vendor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vendor].
 */
public suspend fun vendor(name: String, block: suspend VendorResourceBuilder.() -> Unit): Vendor {
    val builder = VendorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vendor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vendor(name: String): Vendor {
    val builder = VendorResourceBuilder()
    builder.name(name)
    return builder.build()
}
