@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.VendorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Vendor resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### Create or update Vendor resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vendor = new AzureNative.HybridNetwork.Vendor("vendor", new()
 *     {
 *         VendorName = "TestVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewVendor(ctx, "vendor", &hybridnetwork.VendorArgs{
 * 			VendorName: pulumi.String("TestVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.Vendor;
 * import com.pulumi.azurenative.hybridnetwork.VendorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vendor = new Vendor("vendor", VendorArgs.builder()
 *             .vendorName("TestVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:Vendor TestVendor /subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/vendors/{vendorName}
 * ```
 * @property vendorName The name of the vendor.
 */
public data class VendorArgs(
    public val vendorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.VendorArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.VendorArgs =
        com.pulumi.azurenative.hybridnetwork.VendorArgs.builder()
            .vendorName(vendorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VendorArgs].
 */
@PulumiTagMarker
public class VendorArgsBuilder internal constructor() {
    private var vendorName: Output<String>? = null

    /**
     * @param value The name of the vendor.
     */
    @JvmName("gmmbcxijlwarmjpo")
    public suspend fun vendorName(`value`: Output<String>) {
        this.vendorName = value
    }

    /**
     * @param value The name of the vendor.
     */
    @JvmName("rgwrjojuriacrqif")
    public suspend fun vendorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendorName = mapped
    }

    internal fun build(): VendorArgs = VendorArgs(
        vendorName = vendorName,
    )
}
