@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VendorSkuPreview].
 */
@PulumiTagMarker
public class VendorSkuPreviewResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VendorSkuPreviewArgs = VendorSkuPreviewArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VendorSkuPreviewArgsBuilder.() -> Unit) {
        val builder = VendorSkuPreviewArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VendorSkuPreview {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.VendorSkuPreview(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VendorSkuPreview(builtJavaResource)
    }
}

/**
 * Customer subscription which can use a sku.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### Create or update preview subscription of vendor sku sub resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vendorSkuPreview = new AzureNative.HybridNetwork.VendorSkuPreview("vendorSkuPreview", new()
 *     {
 *         PreviewSubscription = "previewSub",
 *         SkuName = "TestSku",
 *         VendorName = "TestVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewVendorSkuPreview(ctx, "vendorSkuPreview", &hybridnetwork.VendorSkuPreviewArgs{
 * 			PreviewSubscription: pulumi.String("previewSub"),
 * 			SkuName:             pulumi.String("TestSku"),
 * 			VendorName:          pulumi.String("TestVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.VendorSkuPreview;
 * import com.pulumi.azurenative.hybridnetwork.VendorSkuPreviewArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vendorSkuPreview = new VendorSkuPreview("vendorSkuPreview", VendorSkuPreviewArgs.builder()
 *             .previewSubscription("previewSub")
 *             .skuName("TestSku")
 *             .vendorName("TestVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:VendorSkuPreview previewSub /subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/vendors/{vendorName}/vendorSkus/{skuName}/previewSubscriptions/{previewSubscription}
 * ```
 */
public class VendorSkuPreview internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.VendorSkuPreview,
) : KotlinCustomResource(javaResource, VendorSkuPreviewMapper) {
    /**
     * The preview subscription ID.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the PreviewSubscription resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VendorSkuPreviewMapper : ResourceMapper<VendorSkuPreview> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.VendorSkuPreview::class == javaResource::class

    override fun map(javaResource: Resource): VendorSkuPreview = VendorSkuPreview(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.VendorSkuPreview,
    )
}

/**
 * @see [VendorSkuPreview].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VendorSkuPreview].
 */
public suspend fun vendorSkuPreview(
    name: String,
    block: suspend VendorSkuPreviewResourceBuilder.() -> Unit,
): VendorSkuPreview {
    val builder = VendorSkuPreviewResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VendorSkuPreview].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vendorSkuPreview(name: String): VendorSkuPreview {
    val builder = VendorSkuPreviewResourceBuilder()
    builder.name(name)
    return builder.build()
}
