@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Template artifact profile.
 * @property templateName Template name.
 * @property templateVersion Template version.
 */
public data class ArmTemplateArtifactProfileArgs(
    public val templateName: Output<String>? = null,
    public val templateVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateArtifactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateArtifactProfileArgs.builder()
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .templateVersion(templateVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArmTemplateArtifactProfileArgs].
 */
@PulumiTagMarker
public class ArmTemplateArtifactProfileArgsBuilder internal constructor() {
    private var templateName: Output<String>? = null

    private var templateVersion: Output<String>? = null

    /**
     * @param value Template name.
     */
    @JvmName("avovoyldchjwxpmb")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value Template version.
     */
    @JvmName("gxvjjvlqfqengbds")
    public suspend fun templateVersion(`value`: Output<String>) {
        this.templateVersion = value
    }

    /**
     * @param value Template name.
     */
    @JvmName("yyfcehlrfxqxpsxe")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value Template version.
     */
    @JvmName("uhynmsscaidisygd")
    public suspend fun templateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersion = mapped
    }

    internal fun build(): ArmTemplateArtifactProfileArgs = ArmTemplateArtifactProfileArgs(
        templateName = templateName,
        templateVersion = templateVersion,
    )
}
