@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateMappingRuleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Template mapping rule profile
 * @property templateParameters List of template parameters.
 */
public data class ArmTemplateMappingRuleProfileArgs(
    public val templateParameters: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateMappingRuleProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ArmTemplateMappingRuleProfileArgs.builder()
            .templateParameters(templateParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArmTemplateMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class ArmTemplateMappingRuleProfileArgsBuilder internal constructor() {
    private var templateParameters: Output<String>? = null

    /**
     * @param value List of template parameters.
     */
    @JvmName("flpmhhtjkfrxmtuq")
    public suspend fun templateParameters(`value`: Output<String>) {
        this.templateParameters = value
    }

    /**
     * @param value List of template parameters.
     */
    @JvmName("idwptbrxmmnckkbo")
    public suspend fun templateParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateParameters = mapped
    }

    internal fun build(): ArmTemplateMappingRuleProfileArgs = ArmTemplateMappingRuleProfileArgs(
        templateParameters = templateParameters,
    )
}
