@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure vhd artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property vhdArtifactProfile Vhd artifact profile.
 */
public data class AzureCoreVhdImageArtifactProfileArgs(
    public val artifactStore: Output<ReferencedResourceArgs>? = null,
    public val vhdArtifactProfile: Output<VhdImageArtifactProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageArtifactProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageArtifactProfileArgs.builder()
            .artifactStore(artifactStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vhdArtifactProfile(
                vhdArtifactProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureCoreVhdImageArtifactProfileArgs].
 */
@PulumiTagMarker
public class AzureCoreVhdImageArtifactProfileArgsBuilder internal constructor() {
    private var artifactStore: Output<ReferencedResourceArgs>? = null

    private var vhdArtifactProfile: Output<VhdImageArtifactProfileArgs>? = null

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("mrksfjrsnxbblwgn")
    public suspend fun artifactStore(`value`: Output<ReferencedResourceArgs>) {
        this.artifactStore = value
    }

    /**
     * @param value Vhd artifact profile.
     */
    @JvmName("omkerruvayegtyjs")
    public suspend fun vhdArtifactProfile(`value`: Output<VhdImageArtifactProfileArgs>) {
        this.vhdArtifactProfile = value
    }

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("ibuyjrqskiuhmqgw")
    public suspend fun artifactStore(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStore = mapped
    }

    /**
     * @param argument The reference to artifact store.
     */
    @JvmName("avrsebcbpbfehnvl")
    public suspend fun artifactStore(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactStore = mapped
    }

    /**
     * @param value Vhd artifact profile.
     */
    @JvmName("jolpypfwnwtesmom")
    public suspend fun vhdArtifactProfile(`value`: VhdImageArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdArtifactProfile = mapped
    }

    /**
     * @param argument Vhd artifact profile.
     */
    @JvmName("xiivncnieeqkbvlw")
    public suspend
    fun vhdArtifactProfile(argument: suspend VhdImageArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VhdImageArtifactProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vhdArtifactProfile = mapped
    }

    internal fun build(): AzureCoreVhdImageArtifactProfileArgs = AzureCoreVhdImageArtifactProfileArgs(
        artifactStore = artifactStore,
        vhdArtifactProfile = vhdArtifactProfile,
    )
}
