@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusArmTemplateArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Operator Distributed Services vhd artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property templateArtifactProfile Template artifact profile.
 */
public data class AzureOperatorNexusArmTemplateArtifactProfileArgs(
    public val artifactStore: Output<ReferencedResourceArgs>? = null,
    public val templateArtifactProfile: Output<ArmTemplateArtifactProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusArmTemplateArtifactProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusArmTemplateArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusArmTemplateArtifactProfileArgs.builder()
            .artifactStore(artifactStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .templateArtifactProfile(
                templateArtifactProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureOperatorNexusArmTemplateArtifactProfileArgs].
 */
@PulumiTagMarker
public class AzureOperatorNexusArmTemplateArtifactProfileArgsBuilder internal constructor() {
    private var artifactStore: Output<ReferencedResourceArgs>? = null

    private var templateArtifactProfile: Output<ArmTemplateArtifactProfileArgs>? = null

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("nwysvacgfeefryqn")
    public suspend fun artifactStore(`value`: Output<ReferencedResourceArgs>) {
        this.artifactStore = value
    }

    /**
     * @param value Template artifact profile.
     */
    @JvmName("tnpjyhauyllfnnju")
    public suspend fun templateArtifactProfile(`value`: Output<ArmTemplateArtifactProfileArgs>) {
        this.templateArtifactProfile = value
    }

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("xwsduktvnaehlnld")
    public suspend fun artifactStore(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStore = mapped
    }

    /**
     * @param argument The reference to artifact store.
     */
    @JvmName("kuwskgctagesfhje")
    public suspend fun artifactStore(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactStore = mapped
    }

    /**
     * @param value Template artifact profile.
     */
    @JvmName("hlvxnqjryjtewlcv")
    public suspend fun templateArtifactProfile(`value`: ArmTemplateArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateArtifactProfile = mapped
    }

    /**
     * @param argument Template artifact profile.
     */
    @JvmName("faxgrkenoewfeswu")
    public suspend
    fun templateArtifactProfile(argument: suspend ArmTemplateArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ArmTemplateArtifactProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateArtifactProfile = mapped
    }

    internal fun build(): AzureOperatorNexusArmTemplateArtifactProfileArgs =
        AzureOperatorNexusArmTemplateArtifactProfileArgs(
            artifactStore = artifactStore,
            templateArtifactProfile = templateArtifactProfile,
        )
}
