@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationGroupSchemaPropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration group schema properties.
 * @property description Description of what schema can contain.
 * @property schemaDefinition Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
 */
public data class ConfigurationGroupSchemaPropertiesFormatArgs(
    public val description: Output<String>? = null,
    public val schemaDefinition: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationGroupSchemaPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationGroupSchemaPropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationGroupSchemaPropertiesFormatArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .schemaDefinition(schemaDefinition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationGroupSchemaPropertiesFormatArgs].
 */
@PulumiTagMarker
public class ConfigurationGroupSchemaPropertiesFormatArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var schemaDefinition: Output<String>? = null

    /**
     * @param value Description of what schema can contain.
     */
    @JvmName("hjdsbdhrstphwwqf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
     */
    @JvmName("iprnulxrjpolrjxx")
    public suspend fun schemaDefinition(`value`: Output<String>) {
        this.schemaDefinition = value
    }

    /**
     * @param value Description of what schema can contain.
     */
    @JvmName("rvbqamvwjqfwxjry")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
     */
    @JvmName("gkfoglibmgwcqybq")
    public suspend fun schemaDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaDefinition = mapped
    }

    internal fun build(): ConfigurationGroupSchemaPropertiesFormatArgs =
        ConfigurationGroupSchemaPropertiesFormatArgs(
            description = description,
            schemaDefinition = schemaDefinition,
        )
}
