@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithSecretsArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ConfigurationValue with secrets.
 * @property configurationGroupSchemaResourceReference The configuration group schema resource reference.
 * @property configurationType The secret type which indicates if secret or not.
 * Expected value is 'Secret'.
 * @property secretConfigurationValue Name and value pairs that define the configuration value secrets. It can be a well formed escaped JSON string.
 */
public data class ConfigurationValueWithSecretsArgs(
    public val configurationGroupSchemaResourceReference:
    Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>? =
        null,
    public val configurationType: Output<String>,
    public val secretConfigurationValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithSecretsArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithSecretsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithSecretsArgs.builder()
            .configurationGroupSchemaResourceReference(
                configurationGroupSchemaResourceReference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .secretConfigurationValue(secretConfigurationValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationValueWithSecretsArgs].
 */
@PulumiTagMarker
public class ConfigurationValueWithSecretsArgsBuilder internal constructor() {
    private var configurationGroupSchemaResourceReference:
        Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>? =
        null

    private var configurationType: Output<String>? = null

    private var secretConfigurationValue: Output<String>? = null

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("jfmlmesqxjvdcdnh")
    public suspend
    fun configurationGroupSchemaResourceReference(`value`: Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>) {
        this.configurationGroupSchemaResourceReference = value
    }

    /**
     * @param value The secret type which indicates if secret or not.
     * Expected value is 'Secret'.
     */
    @JvmName("scoumbnfuojlkfge")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value Name and value pairs that define the configuration value secrets. It can be a well formed escaped JSON string.
     */
    @JvmName("nnjakathklkifsbi")
    public suspend fun secretConfigurationValue(`value`: Output<String>) {
        this.secretConfigurationValue = value
    }

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("jfmnvpmneexexiqr")
    public suspend
    fun configurationGroupSchemaResourceReference(`value`: Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationGroupSchemaResourceReference = mapped
    }

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("ynuudsmqlbeucurx")
    public
    fun configurationGroupSchemaResourceReference(`value`: OpenDeploymentResourceReferenceArgs) {
        val toBeMapped = Either.ofLeft<OpenDeploymentResourceReferenceArgs,
            SecretDeploymentResourceReferenceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationGroupSchemaResourceReference = mapped
    }

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("fwycndaihjbgspma")
    public
    fun configurationGroupSchemaResourceReference(`value`: SecretDeploymentResourceReferenceArgs) {
        val toBeMapped = Either.ofRight<OpenDeploymentResourceReferenceArgs,
            SecretDeploymentResourceReferenceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationGroupSchemaResourceReference = mapped
    }

    /**
     * @param value The secret type which indicates if secret or not.
     * Expected value is 'Secret'.
     */
    @JvmName("rjjqcriirbldbnbo")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Name and value pairs that define the configuration value secrets. It can be a well formed escaped JSON string.
     */
    @JvmName("xlolnjwcflifoymt")
    public suspend fun secretConfigurationValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretConfigurationValue = mapped
    }

    internal fun build(): ConfigurationValueWithSecretsArgs = ConfigurationValueWithSecretsArgs(
        configurationGroupSchemaResourceReference = configurationGroupSchemaResourceReference,
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        secretConfigurationValue = secretConfigurationValue,
    )
}
