@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ContainerizedNetworkFunctionDefinitionVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Containerized network function network function definition version properties.
 * @property deployParameters The deployment parameters of the network function definition version.
 * @property description The network function definition version description.
 * @property networkFunctionTemplate Containerized network function template.
 * @property networkFunctionType The network function type.
 * Expected value is 'ContainerizedNetworkFunction'.
 */
public data class ContainerizedNetworkFunctionDefinitionVersionArgs(
    public val deployParameters: Output<String>? = null,
    public val description: Output<String>? = null,
    public val networkFunctionTemplate: Output<AzureArcKubernetesNetworkFunctionTemplateArgs>? = null,
    public val networkFunctionType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ContainerizedNetworkFunctionDefinitionVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ContainerizedNetworkFunctionDefinitionVersionArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ContainerizedNetworkFunctionDefinitionVersionArgs.builder()
            .deployParameters(deployParameters?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .networkFunctionTemplate(
                networkFunctionTemplate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkFunctionType(networkFunctionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerizedNetworkFunctionDefinitionVersionArgs].
 */
@PulumiTagMarker
public class ContainerizedNetworkFunctionDefinitionVersionArgsBuilder internal constructor() {
    private var deployParameters: Output<String>? = null

    private var description: Output<String>? = null

    private var networkFunctionTemplate: Output<AzureArcKubernetesNetworkFunctionTemplateArgs>? = null

    private var networkFunctionType: Output<String>? = null

    /**
     * @param value The deployment parameters of the network function definition version.
     */
    @JvmName("gcfirokixytjlinl")
    public suspend fun deployParameters(`value`: Output<String>) {
        this.deployParameters = value
    }

    /**
     * @param value The network function definition version description.
     */
    @JvmName("ajqbvujmkjwevqsy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Containerized network function template.
     */
    @JvmName("jfmcwecupmmjsqyl")
    public suspend
    fun networkFunctionTemplate(`value`: Output<AzureArcKubernetesNetworkFunctionTemplateArgs>) {
        this.networkFunctionTemplate = value
    }

    /**
     * @param value The network function type.
     * Expected value is 'ContainerizedNetworkFunction'.
     */
    @JvmName("jpcsgewwsdjpelep")
    public suspend fun networkFunctionType(`value`: Output<String>) {
        this.networkFunctionType = value
    }

    /**
     * @param value The deployment parameters of the network function definition version.
     */
    @JvmName("aicviayehyxipldj")
    public suspend fun deployParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParameters = mapped
    }

    /**
     * @param value The network function definition version description.
     */
    @JvmName("ydirbwcrgyxkjvpc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Containerized network function template.
     */
    @JvmName("qyxvubuwvwrmghwn")
    public suspend
    fun networkFunctionTemplate(`value`: AzureArcKubernetesNetworkFunctionTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionTemplate = mapped
    }

    /**
     * @param argument Containerized network function template.
     */
    @JvmName("twbhkhmgoupkcron")
    public suspend
    fun networkFunctionTemplate(argument: suspend AzureArcKubernetesNetworkFunctionTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = AzureArcKubernetesNetworkFunctionTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkFunctionTemplate = mapped
    }

    /**
     * @param value The network function type.
     * Expected value is 'ContainerizedNetworkFunction'.
     */
    @JvmName("ebuokdptxpsokdbk")
    public suspend fun networkFunctionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionType = mapped
    }

    internal fun build(): ContainerizedNetworkFunctionDefinitionVersionArgs =
        ContainerizedNetworkFunctionDefinitionVersionArgs(
            deployParameters = deployParameters,
            description = description,
            networkFunctionTemplate = networkFunctionTemplate,
            networkFunctionType = networkFunctionType ?: throw PulumiNullFieldException("networkFunctionType"),
        )
}
