@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.DataDiskArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.DiskCreateOptionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
 * @property createOption Specifies how the virtual machine should be created.
 * @property diskSizeGB Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
 * @property name The name of data disk.
 */
public data class DataDiskArgs(
    public val createOption: Output<Either<String, DiskCreateOptionTypes>>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.DataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.DataDiskArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.DataDiskArgs.builder()
            .createOption(
                createOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataDiskArgs].
 */
@PulumiTagMarker
public class DataDiskArgsBuilder internal constructor() {
    private var createOption: Output<Either<String, DiskCreateOptionTypes>>? = null

    private var diskSizeGB: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value Specifies how the virtual machine should be created.
     */
    @JvmName("rhmmdgexpmqlqabw")
    public suspend fun createOption(`value`: Output<Either<String, DiskCreateOptionTypes>>) {
        this.createOption = value
    }

    /**
     * @param value Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
     */
    @JvmName("atahogyweimnnbnm")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value The name of data disk.
     */
    @JvmName("iprkuxjmluylkavi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies how the virtual machine should be created.
     */
    @JvmName("iamwblwncwhgaexi")
    public suspend fun createOption(`value`: Either<String, DiskCreateOptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created.
     */
    @JvmName("srdxhvjjtluualyd")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created.
     */
    @JvmName("nucicfnumtbfwaci")
    public fun createOption(`value`: DiskCreateOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
     */
    @JvmName("hjgyjssdrqclouqs")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value The name of data disk.
     */
    @JvmName("uodwyncdlhadxfep")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DataDiskArgs = DataDiskArgs(
        createOption = createOption,
        diskSizeGB = diskSizeGB,
        name = name,
    )
}
