@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactManifestPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactManifestName The name of the artifact manifest.
 * @property artifactStoreName The name of the artifact store.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetArtifactManifestPlainArgs(
    public val artifactManifestName: String,
    public val artifactStoreName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactManifestPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactManifestPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactManifestPlainArgs.builder()
            .artifactManifestName(artifactManifestName.let({ args0 -> args0 }))
            .artifactStoreName(artifactStoreName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArtifactManifestPlainArgs].
 */
@PulumiTagMarker
public class GetArtifactManifestPlainArgsBuilder internal constructor() {
    private var artifactManifestName: String? = null

    private var artifactStoreName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the artifact manifest.
     */
    @JvmName("jtlhpgpwpfakkhkr")
    public suspend fun artifactManifestName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.artifactManifestName = mapped
    }

    /**
     * @param value The name of the artifact store.
     */
    @JvmName("uudyylehdbtyiiuq")
    public suspend fun artifactStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.artifactStoreName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("ylclkblrtmlqoesw")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ltrbhhkuurglbhej")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetArtifactManifestPlainArgs = GetArtifactManifestPlainArgs(
        artifactManifestName = artifactManifestName ?: throw
            PulumiNullFieldException("artifactManifestName"),
        artifactStoreName = artifactStoreName ?: throw PulumiNullFieldException("artifactStoreName"),
        publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
