@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationGroupValueName The name of the configuration group value.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConfigurationGroupValuePlainArgs(
    public val configurationGroupValueName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupValuePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupValuePlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupValuePlainArgs.builder()
            .configurationGroupValueName(configurationGroupValueName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationGroupValuePlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationGroupValuePlainArgsBuilder internal constructor() {
    private var configurationGroupValueName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the configuration group value.
     */
    @JvmName("rdvmoqhdauegugjv")
    public suspend fun configurationGroupValueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationGroupValueName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lgxaqpaqvbuphxmu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationGroupValuePlainArgs = GetConfigurationGroupValuePlainArgs(
        configurationGroupValueName = configurationGroupValueName ?: throw
            PulumiNullFieldException("configurationGroupValueName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
