@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkFunctionName The name of the network function resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkFunctionPlainArgs(
    public val networkFunctionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionPlainArgs.builder()
            .networkFunctionName(networkFunctionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkFunctionPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkFunctionPlainArgsBuilder internal constructor() {
    private var networkFunctionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network function resource.
     */
    @JvmName("vmbbswutojjjtxwq")
    public suspend fun networkFunctionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFunctionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("trdachrowpghcenx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkFunctionPlainArgs = GetNetworkFunctionPlainArgs(
        networkFunctionName = networkFunctionName ?: throw PulumiNullFieldException("networkFunctionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
