@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkServiceDesignGroupName The name of the network service design group.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkServiceDesignGroupPlainArgs(
    public val networkServiceDesignGroupName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignGroupPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignGroupPlainArgs.builder()
            .networkServiceDesignGroupName(networkServiceDesignGroupName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkServiceDesignGroupPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkServiceDesignGroupPlainArgsBuilder internal constructor() {
    private var networkServiceDesignGroupName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network service design group.
     */
    @JvmName("rdlxyguprnfsrlyt")
    public suspend fun networkServiceDesignGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkServiceDesignGroupName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("obrvmshfsjjmnnyd")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fmoytxtblvtpydoy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkServiceDesignGroupPlainArgs =
        GetNetworkServiceDesignGroupPlainArgs(
            networkServiceDesignGroupName = networkServiceDesignGroupName ?: throw
                PulumiNullFieldException("networkServiceDesignGroupName"),
            publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
