@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetPublisherPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPublisherPlainArgs(
    public val publisherName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetPublisherPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetPublisherPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetPublisherPlainArgs.builder()
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublisherPlainArgs].
 */
@PulumiTagMarker
public class GetPublisherPlainArgsBuilder internal constructor() {
    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the publisher.
     */
    @JvmName("spkmwcwwifewmdjc")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("inqbylgtaqpgkloa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPublisherPlainArgs = GetPublisherPlainArgs(
        publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
