@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ImageMappingRuleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image mapping rule profile
 * @property userConfiguration List of values.
 */
public data class ImageMappingRuleProfileArgs(
    public val userConfiguration: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ImageMappingRuleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ImageMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ImageMappingRuleProfileArgs.builder()
            .userConfiguration(userConfiguration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class ImageMappingRuleProfileArgsBuilder internal constructor() {
    private var userConfiguration: Output<String>? = null

    /**
     * @param value List of values.
     */
    @JvmName("qjkaucrvkthrallr")
    public suspend fun userConfiguration(`value`: Output<String>) {
        this.userConfiguration = value
    }

    /**
     * @param value List of values.
     */
    @JvmName("dkontherfyqgbjrr")
    public suspend fun userConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userConfiguration = mapped
    }

    internal fun build(): ImageMappingRuleProfileArgs = ImageMappingRuleProfileArgs(
        userConfiguration = userConfiguration,
    )
}
