@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionResourceElementTemplateDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The network function definition resource element template details.
 * @property configuration The resource element template type.
 * @property dependsOnProfile The depends on profile.
 * @property name Name of the resource element template.
 * @property resourceElementType The resource element template type.
 * Expected value is 'NetworkFunctionDefinition'.
 */
public data class NetworkFunctionDefinitionResourceElementTemplateDetailsArgs(
    public val configuration: Output<ArmResourceDefinitionResourceElementTemplateArgs>? = null,
    public val dependsOnProfile: Output<DependsOnProfileArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceElementType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionResourceElementTemplateDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionResourceElementTemplateDetailsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionResourceElementTemplateDetailsArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dependsOnProfile(dependsOnProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceElementType(resourceElementType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkFunctionDefinitionResourceElementTemplateDetailsArgs].
 */
@PulumiTagMarker
public class NetworkFunctionDefinitionResourceElementTemplateDetailsArgsBuilder internal
constructor() {
    private var configuration: Output<ArmResourceDefinitionResourceElementTemplateArgs>? = null

    private var dependsOnProfile: Output<DependsOnProfileArgs>? = null

    private var name: Output<String>? = null

    private var resourceElementType: Output<String>? = null

    /**
     * @param value The resource element template type.
     */
    @JvmName("nqorrqetgevlahvh")
    public suspend
    fun configuration(`value`: Output<ArmResourceDefinitionResourceElementTemplateArgs>) {
        this.configuration = value
    }

    /**
     * @param value The depends on profile.
     */
    @JvmName("tutfeturrhpyxgda")
    public suspend fun dependsOnProfile(`value`: Output<DependsOnProfileArgs>) {
        this.dependsOnProfile = value
    }

    /**
     * @param value Name of the resource element template.
     */
    @JvmName("durlehqajoydumid")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource element template type.
     * Expected value is 'NetworkFunctionDefinition'.
     */
    @JvmName("jjsytpfrgytwibuq")
    public suspend fun resourceElementType(`value`: Output<String>) {
        this.resourceElementType = value
    }

    /**
     * @param value The resource element template type.
     */
    @JvmName("evknvtqrgckmcbmu")
    public suspend fun configuration(`value`: ArmResourceDefinitionResourceElementTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument The resource element template type.
     */
    @JvmName("ttsibiawibcqsthv")
    public suspend
    fun configuration(argument: suspend ArmResourceDefinitionResourceElementTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = ArmResourceDefinitionResourceElementTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The depends on profile.
     */
    @JvmName("kritfgumqgtupufe")
    public suspend fun dependsOnProfile(`value`: DependsOnProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnProfile = mapped
    }

    /**
     * @param argument The depends on profile.
     */
    @JvmName("lmonhlgiwfykgsui")
    public suspend fun dependsOnProfile(argument: suspend DependsOnProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DependsOnProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependsOnProfile = mapped
    }

    /**
     * @param value Name of the resource element template.
     */
    @JvmName("mxrskhxiuekbvrdr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource element template type.
     * Expected value is 'NetworkFunctionDefinition'.
     */
    @JvmName("scqyhxymfowksesr")
    public suspend fun resourceElementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceElementType = mapped
    }

    internal fun build(): NetworkFunctionDefinitionResourceElementTemplateDetailsArgs =
        NetworkFunctionDefinitionResourceElementTemplateDetailsArgs(
            configuration = configuration,
            dependsOnProfile = dependsOnProfile,
            name = name,
            resourceElementType = resourceElementType ?: throw PulumiNullFieldException("resourceElementType"),
        )
}
