@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.VMSwitchType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network interface properties.
 * @property ipConfigurations A list of IP configurations of the network interface.
 * @property macAddress The MAC address of the network interface.
 * @property networkInterfaceName The name of the network interface.
 * @property vmSwitchType The type of the VM switch.
 */
public data class NetworkInterfaceArgs(
    public val ipConfigurations: Output<List<NetworkInterfaceIPConfigurationArgs>>? = null,
    public val macAddress: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val vmSwitchType: Output<Either<String, VMSwitchType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceArgs.builder()
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .macAddress(macAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .vmSwitchType(
                vmSwitchType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var ipConfigurations: Output<List<NetworkInterfaceIPConfigurationArgs>>? = null

    private var macAddress: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var vmSwitchType: Output<Either<String, VMSwitchType>>? = null

    /**
     * @param value A list of IP configurations of the network interface.
     */
    @JvmName("cgbroaibswmulfvs")
    public suspend fun ipConfigurations(`value`: Output<List<NetworkInterfaceIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("rlmfxvwjgqqqmffq")
    public suspend fun ipConfigurations(vararg values: Output<NetworkInterfaceIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of IP configurations of the network interface.
     */
    @JvmName("btsikrxnaneuwjuj")
    public suspend fun ipConfigurations(values: List<Output<NetworkInterfaceIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The MAC address of the network interface.
     */
    @JvmName("qsxywqnwnswvfajf")
    public suspend fun macAddress(`value`: Output<String>) {
        this.macAddress = value
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("omscvdjqdiauwubc")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The type of the VM switch.
     */
    @JvmName("tsqplqljmxfsbnip")
    public suspend fun vmSwitchType(`value`: Output<Either<String, VMSwitchType>>) {
        this.vmSwitchType = value
    }

    /**
     * @param value A list of IP configurations of the network interface.
     */
    @JvmName("bjoxyvxyxmkjemnl")
    public suspend fun ipConfigurations(`value`: List<NetworkInterfaceIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IP configurations of the network interface.
     */
    @JvmName("rgswbcjplfjfosft")
    public suspend
    fun ipConfigurations(argument: List<suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IP configurations of the network interface.
     */
    @JvmName("creoxahfdkyrvxrl")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IP configurations of the network interface.
     */
    @JvmName("gdbtdfaegnccenni")
    public suspend
    fun ipConfigurations(argument: suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkInterfaceIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values A list of IP configurations of the network interface.
     */
    @JvmName("tmpcssveehpblcmc")
    public suspend fun ipConfigurations(vararg values: NetworkInterfaceIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The MAC address of the network interface.
     */
    @JvmName("hlnjuyoigbdnlrdy")
    public suspend fun macAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macAddress = mapped
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("fvdjlovrtvijduew")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The type of the VM switch.
     */
    @JvmName("tygpvevwqulaaajr")
    public suspend fun vmSwitchType(`value`: Either<String, VMSwitchType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSwitchType = mapped
    }

    /**
     * @param value The type of the VM switch.
     */
    @JvmName("mvvtbvahcvimfnxl")
    public fun vmSwitchType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VMSwitchType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSwitchType = mapped
    }

    /**
     * @param value The type of the VM switch.
     */
    @JvmName("yvehemjhtppjqkqm")
    public fun vmSwitchType(`value`: VMSwitchType) {
        val toBeMapped = Either.ofRight<String, VMSwitchType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSwitchType = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        ipConfigurations = ipConfigurations,
        macAddress = macAddress,
        networkInterfaceName = networkInterfaceName,
        vmSwitchType = vmSwitchType,
    )
}
