@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.VhdImageMappingRuleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Vhd mapping rule profile
 * @property userConfiguration List of values.
 */
public data class VhdImageMappingRuleProfileArgs(
    public val userConfiguration: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.VhdImageMappingRuleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.VhdImageMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.VhdImageMappingRuleProfileArgs.builder()
            .userConfiguration(userConfiguration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VhdImageMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class VhdImageMappingRuleProfileArgsBuilder internal constructor() {
    private var userConfiguration: Output<String>? = null

    /**
     * @param value List of values.
     */
    @JvmName("nxkewxuaeqpxkqsl")
    public suspend fun userConfiguration(`value`: Output<String>) {
        this.userConfiguration = value
    }

    /**
     * @param value List of values.
     */
    @JvmName("dvqwagpofyuvgoyi")
    public suspend fun userConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userConfiguration = mapped
    }

    internal fun build(): VhdImageMappingRuleProfileArgs = VhdImageMappingRuleProfileArgs(
        userConfiguration = userConfiguration,
    )
}
