@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual network function network function definition version properties.
 * @property deployParameters The deployment parameters of the network function definition version.
 * @property description The network function definition version description.
 * @property networkFunctionTemplate Virtual network function template.
 * @property networkFunctionType The network function type.
 * Expected value is 'VirtualNetworkFunction'.
 */
public data class VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs(
    public val deployParameters: Output<String>? = null,
    public val description: Output<String>? = null,
    public val networkFunctionTemplate:
    Output<Either<AzureCoreNetworkFunctionTemplateArgs, AzureOperatorNexusNetworkFunctionTemplateArgs>>? =
        null,
    public val networkFunctionType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs.builder()
            .deployParameters(deployParameters?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .networkFunctionTemplate(
                networkFunctionTemplate?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .networkFunctionType(networkFunctionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs].
 */
@PulumiTagMarker
public class VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgsBuilder internal
constructor() {
    private var deployParameters: Output<String>? = null

    private var description: Output<String>? = null

    private var networkFunctionTemplate:
        Output<Either<AzureCoreNetworkFunctionTemplateArgs, AzureOperatorNexusNetworkFunctionTemplateArgs>>? =
        null

    private var networkFunctionType: Output<String>? = null

    /**
     * @param value The deployment parameters of the network function definition version.
     */
    @JvmName("cvlafrsmnqaluoqx")
    public suspend fun deployParameters(`value`: Output<String>) {
        this.deployParameters = value
    }

    /**
     * @param value The network function definition version description.
     */
    @JvmName("jcbwswepqrosdjiy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Virtual network function template.
     */
    @JvmName("ocpuhnknrclcwnmc")
    public suspend
    fun networkFunctionTemplate(`value`: Output<Either<AzureCoreNetworkFunctionTemplateArgs, AzureOperatorNexusNetworkFunctionTemplateArgs>>) {
        this.networkFunctionTemplate = value
    }

    /**
     * @param value The network function type.
     * Expected value is 'VirtualNetworkFunction'.
     */
    @JvmName("rfopsgdgqompydnj")
    public suspend fun networkFunctionType(`value`: Output<String>) {
        this.networkFunctionType = value
    }

    /**
     * @param value The deployment parameters of the network function definition version.
     */
    @JvmName("nwcofiqaxrsvbkqj")
    public suspend fun deployParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParameters = mapped
    }

    /**
     * @param value The network function definition version description.
     */
    @JvmName("qmgqmvdxbtnvsbmv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Virtual network function template.
     */
    @JvmName("pemxajwnpcmwwjgb")
    public suspend
    fun networkFunctionTemplate(`value`: Either<AzureCoreNetworkFunctionTemplateArgs, AzureOperatorNexusNetworkFunctionTemplateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionTemplate = mapped
    }

    /**
     * @param value Virtual network function template.
     */
    @JvmName("xvxkeugjkxyfwiej")
    public fun networkFunctionTemplate(`value`: AzureCoreNetworkFunctionTemplateArgs) {
        val toBeMapped = Either.ofLeft<AzureCoreNetworkFunctionTemplateArgs,
            AzureOperatorNexusNetworkFunctionTemplateArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionTemplate = mapped
    }

    /**
     * @param value Virtual network function template.
     */
    @JvmName("ctaqeomprvsxkpdu")
    public fun networkFunctionTemplate(`value`: AzureOperatorNexusNetworkFunctionTemplateArgs) {
        val toBeMapped = Either.ofRight<AzureCoreNetworkFunctionTemplateArgs,
            AzureOperatorNexusNetworkFunctionTemplateArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionTemplate = mapped
    }

    /**
     * @param value The network function type.
     * Expected value is 'VirtualNetworkFunction'.
     */
    @JvmName("acihqmajcwexvswy")
    public suspend fun networkFunctionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionType = mapped
    }

    internal fun build(): VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs =
        VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs(
            deployParameters = deployParameters,
            description = description,
            networkFunctionTemplate = networkFunctionTemplate,
            networkFunctionType = networkFunctionType ?: throw PulumiNullFieldException("networkFunctionType"),
        )
}
