@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Azure Core NFVI detail.
 * @property location Location of the Azure core.
 * @property name Name of the nfvi.
 * @property nfviType The NFVI type.
 * Expected value is 'AzureCore'.
 */
public data class AzureCoreNFVIDetailsResponse(
    public val location: String? = null,
    public val name: String? = null,
    public val nfviType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreNFVIDetailsResponse):
            AzureCoreNFVIDetailsResponse = AzureCoreNFVIDetailsResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nfviType = javaType.nfviType(),
        )
    }
}
