@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure vhd deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property vhdImageMappingRuleProfile The vhd mapping rule profile.
 */
public data class AzureCoreVhdImageDeployMappingRuleProfileResponse(
    public val applicationEnablement: String? = null,
    public val vhdImageMappingRuleProfile: VhdImageMappingRuleProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreVhdImageDeployMappingRuleProfileResponse):
            AzureCoreVhdImageDeployMappingRuleProfileResponse =
            AzureCoreVhdImageDeployMappingRuleProfileResponse(
                applicationEnablement = javaType.applicationEnablement().map({ args0 -> args0 }).orElse(null),
                vhdImageMappingRuleProfile = javaType.vhdImageMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.VhdImageMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
