@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer subscription which can use a sku.
 * @property id The ARM ID of the resource.
 * @property name The preview subscription ID.
 * @property provisioningState The provisioning state of the PreviewSubscription resource.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource.
 */
public data class GetVendorSkuPreviewResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.GetVendorSkuPreviewResult):
            GetVendorSkuPreviewResult = GetVendorSkuPreviewResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
