@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network function user configuration.
 * @property networkInterfaces The network interface configuration.
 * @property osProfile Specifies the operating system settings for the role instance.
 * @property roleName The name of the network function role.
 * @property userDataParameters The user data parameters from the customer.
 */
public data class NetworkFunctionUserConfigurationResponse(
    public val networkInterfaces: List<NetworkInterfaceResponse>? = null,
    public val osProfile: NetworkFunctionUserConfigurationResponseOsProfile? = null,
    public val roleName: String? = null,
    public val userDataParameters: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkFunctionUserConfigurationResponse):
            NetworkFunctionUserConfigurationResponse = NetworkFunctionUserConfigurationResponse(
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionUserConfigurationResponseOsProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            userDataParameters = javaType.userDataParameters().map({ args0 -> args0 }).orElse(null),
        )
    }
}
