@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Site network service properties.
 * @property desiredStateConfigurationGroupValueReferences The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service.
 * @property lastStateConfigurationGroupValueReferences The last state of the site network service resource.
 * @property lastStateNetworkServiceDesignVersionName The network service design version for the site network service.
 * @property managedResourceGroupConfiguration Managed resource group configuration.
 * @property networkServiceDesignGroupName The network service design group name for the site network service.
 * @property networkServiceDesignVersionName The network service design version for the site network service.
 * @property networkServiceDesignVersionOfferingLocation The location of the network service design offering.
 * @property networkServiceDesignVersionResourceReference The network service design version resource reference.
 * @property provisioningState The provisioning state of the site network service resource.
 * @property publisherName The publisher name for the site network service.
 * @property publisherScope The scope of the publisher.
 * @property siteReference The site details
 */
public data class SiteNetworkServicePropertiesFormatResponse(
    public val desiredStateConfigurationGroupValueReferences: Map<String, ReferencedResourceResponse>? =
        null,
    public val lastStateConfigurationGroupValueReferences: Map<String, ReferencedResourceResponse>,
    public val lastStateNetworkServiceDesignVersionName: String,
    public val managedResourceGroupConfiguration: ManagedResourceGroupConfigurationResponse? = null,
    public val networkServiceDesignGroupName: String,
    public val networkServiceDesignVersionName: String,
    public val networkServiceDesignVersionOfferingLocation: String,
    public val networkServiceDesignVersionResourceReference:
    Either<OpenDeploymentResourceReferenceResponse, SecretDeploymentResourceReferenceResponse>? =
        null,
    public val provisioningState: String,
    public val publisherName: String,
    public val publisherScope: String,
    public val siteReference: ReferencedResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.SiteNetworkServicePropertiesFormatResponse):
            SiteNetworkServicePropertiesFormatResponse = SiteNetworkServicePropertiesFormatResponse(
            desiredStateConfigurationGroupValueReferences = javaType.desiredStateConfigurationGroupValueReferences().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            lastStateConfigurationGroupValueReferences = javaType.lastStateConfigurationGroupValueReferences().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            lastStateNetworkServiceDesignVersionName = javaType.lastStateNetworkServiceDesignVersionName(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkServiceDesignGroupName = javaType.networkServiceDesignGroupName(),
            networkServiceDesignVersionName = javaType.networkServiceDesignVersionName(),
            networkServiceDesignVersionOfferingLocation = javaType.networkServiceDesignVersionOfferingLocation(),
            networkServiceDesignVersionResourceReference = javaType.networkServiceDesignVersionResourceReference().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.OpenDeploymentResourceReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SecretDeploymentResourceReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publisherName = javaType.publisherName(),
            publisherScope = javaType.publisherScope(),
            siteReference = javaType.siteReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
