@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the storage settings for the virtual machine disks.
 * @property dataDisks Specifies the parameters that are used to add a data disk to a virtual machine.
 * @property imageReference The image reference properties.
 * @property osDisk Specifies information about the operating system disk used by the virtual machine.
 */
public data class StorageProfileResponse(
    public val dataDisks: List<DataDiskResponse>? = null,
    public val imageReference: ImageReferenceResponse? = null,
    public val osDisk: OsDiskResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.StorageProfileResponse):
            StorageProfileResponse = StorageProfileResponse(
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.DataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            imageReference = javaType.imageReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osDisk = javaType.osDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.OsDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
