@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.DeliveryPackageInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about the delivery package being shipped by the customer to the Microsoft data center.
 * @property carrierName The name of the carrier that is used to ship the import or export drives.
 * @property driveCount The number of drives included in the package.
 * @property shipDate The date when the package is shipped.
 * @property trackingNumber The tracking number of the package.
 */
public data class DeliveryPackageInformationArgs(
    public val carrierName: Output<String>,
    public val driveCount: Output<Double>? = null,
    public val shipDate: Output<String>? = null,
    public val trackingNumber: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.DeliveryPackageInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.DeliveryPackageInformationArgs =
        com.pulumi.azurenative.importexport.inputs.DeliveryPackageInformationArgs.builder()
            .carrierName(carrierName.applyValue({ args0 -> args0 }))
            .driveCount(driveCount?.applyValue({ args0 -> args0 }))
            .shipDate(shipDate?.applyValue({ args0 -> args0 }))
            .trackingNumber(trackingNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeliveryPackageInformationArgs].
 */
@PulumiTagMarker
public class DeliveryPackageInformationArgsBuilder internal constructor() {
    private var carrierName: Output<String>? = null

    private var driveCount: Output<Double>? = null

    private var shipDate: Output<String>? = null

    private var trackingNumber: Output<String>? = null

    /**
     * @param value The name of the carrier that is used to ship the import or export drives.
     */
    @JvmName("vvtojoqovkcedbgj")
    public suspend fun carrierName(`value`: Output<String>) {
        this.carrierName = value
    }

    /**
     * @param value The number of drives included in the package.
     */
    @JvmName("ragbgjpjepavbtqw")
    public suspend fun driveCount(`value`: Output<Double>) {
        this.driveCount = value
    }

    /**
     * @param value The date when the package is shipped.
     */
    @JvmName("khmemnhbntbvkdtx")
    public suspend fun shipDate(`value`: Output<String>) {
        this.shipDate = value
    }

    /**
     * @param value The tracking number of the package.
     */
    @JvmName("nmffxuoyevnucifo")
    public suspend fun trackingNumber(`value`: Output<String>) {
        this.trackingNumber = value
    }

    /**
     * @param value The name of the carrier that is used to ship the import or export drives.
     */
    @JvmName("shltqrcoyoeuivjh")
    public suspend fun carrierName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.carrierName = mapped
    }

    /**
     * @param value The number of drives included in the package.
     */
    @JvmName("eeifiubasgpgwmxu")
    public suspend fun driveCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driveCount = mapped
    }

    /**
     * @param value The date when the package is shipped.
     */
    @JvmName("ffvtugnolyyykblu")
    public suspend fun shipDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shipDate = mapped
    }

    /**
     * @param value The tracking number of the package.
     */
    @JvmName("qiuqsrfjmgrbgtum")
    public suspend fun trackingNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackingNumber = mapped
    }

    internal fun build(): DeliveryPackageInformationArgs = DeliveryPackageInformationArgs(
        carrierName = carrierName ?: throw PulumiNullFieldException("carrierName"),
        driveCount = driveCount,
        shipDate = shipDate,
        trackingNumber = trackingNumber ?: throw PulumiNullFieldException("trackingNumber"),
    )
}
