@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.DriveStatusArgs.builder
import com.pulumi.azurenative.importexport.kotlin.enums.DriveState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides information about the drive's status
 * @property bitLockerKey The BitLocker key used to encrypt the drive.
 * @property bytesSucceeded Bytes successfully transferred for the drive.
 * @property copyStatus Detailed status about the data transfer process. This field is not returned in the response until the drive is in the Transferring state.
 * @property driveHeaderHash The drive header hash value.
 * @property driveId The drive's hardware serial number, without spaces.
 * @property errorLogUri A URI that points to the blob containing the error log for the data transfer operation.
 * @property manifestFile The relative path of the manifest file on the drive.
 * @property manifestHash The Base16-encoded MD5 hash of the manifest file on the drive.
 * @property manifestUri A URI that points to the blob containing the drive manifest file.
 * @property percentComplete Percentage completed for the drive.
 * @property state The drive's current state.
 * @property verboseLogUri A URI that points to the blob containing the verbose log for the data transfer operation.
 */
public data class DriveStatusArgs(
    public val bitLockerKey: Output<String>? = null,
    public val bytesSucceeded: Output<Double>? = null,
    public val copyStatus: Output<String>? = null,
    public val driveHeaderHash: Output<String>? = null,
    public val driveId: Output<String>? = null,
    public val errorLogUri: Output<String>? = null,
    public val manifestFile: Output<String>? = null,
    public val manifestHash: Output<String>? = null,
    public val manifestUri: Output<String>? = null,
    public val percentComplete: Output<Double>? = null,
    public val state: Output<Either<String, DriveState>>? = null,
    public val verboseLogUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.DriveStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.DriveStatusArgs =
        com.pulumi.azurenative.importexport.inputs.DriveStatusArgs.builder()
            .bitLockerKey(bitLockerKey?.applyValue({ args0 -> args0 }))
            .bytesSucceeded(bytesSucceeded?.applyValue({ args0 -> args0 }))
            .copyStatus(copyStatus?.applyValue({ args0 -> args0 }))
            .driveHeaderHash(driveHeaderHash?.applyValue({ args0 -> args0 }))
            .driveId(driveId?.applyValue({ args0 -> args0 }))
            .errorLogUri(errorLogUri?.applyValue({ args0 -> args0 }))
            .manifestFile(manifestFile?.applyValue({ args0 -> args0 }))
            .manifestHash(manifestHash?.applyValue({ args0 -> args0 }))
            .manifestUri(manifestUri?.applyValue({ args0 -> args0 }))
            .percentComplete(percentComplete?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .verboseLogUri(verboseLogUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DriveStatusArgs].
 */
@PulumiTagMarker
public class DriveStatusArgsBuilder internal constructor() {
    private var bitLockerKey: Output<String>? = null

    private var bytesSucceeded: Output<Double>? = null

    private var copyStatus: Output<String>? = null

    private var driveHeaderHash: Output<String>? = null

    private var driveId: Output<String>? = null

    private var errorLogUri: Output<String>? = null

    private var manifestFile: Output<String>? = null

    private var manifestHash: Output<String>? = null

    private var manifestUri: Output<String>? = null

    private var percentComplete: Output<Double>? = null

    private var state: Output<Either<String, DriveState>>? = null

    private var verboseLogUri: Output<String>? = null

    /**
     * @param value The BitLocker key used to encrypt the drive.
     */
    @JvmName("mhsyxosrwkkcohbb")
    public suspend fun bitLockerKey(`value`: Output<String>) {
        this.bitLockerKey = value
    }

    /**
     * @param value Bytes successfully transferred for the drive.
     */
    @JvmName("ihwxqwtfdcsvysac")
    public suspend fun bytesSucceeded(`value`: Output<Double>) {
        this.bytesSucceeded = value
    }

    /**
     * @param value Detailed status about the data transfer process. This field is not returned in the response until the drive is in the Transferring state.
     */
    @JvmName("eevxckrdjacffklu")
    public suspend fun copyStatus(`value`: Output<String>) {
        this.copyStatus = value
    }

    /**
     * @param value The drive header hash value.
     */
    @JvmName("bkfyhqhntfvxwwqc")
    public suspend fun driveHeaderHash(`value`: Output<String>) {
        this.driveHeaderHash = value
    }

    /**
     * @param value The drive's hardware serial number, without spaces.
     */
    @JvmName("vxnfhbrikilhovbc")
    public suspend fun driveId(`value`: Output<String>) {
        this.driveId = value
    }

    /**
     * @param value A URI that points to the blob containing the error log for the data transfer operation.
     */
    @JvmName("nisklwmuhbfknxch")
    public suspend fun errorLogUri(`value`: Output<String>) {
        this.errorLogUri = value
    }

    /**
     * @param value The relative path of the manifest file on the drive.
     */
    @JvmName("epraxyjvfkfskuxe")
    public suspend fun manifestFile(`value`: Output<String>) {
        this.manifestFile = value
    }

    /**
     * @param value The Base16-encoded MD5 hash of the manifest file on the drive.
     */
    @JvmName("vxcpmbfvhxerqkis")
    public suspend fun manifestHash(`value`: Output<String>) {
        this.manifestHash = value
    }

    /**
     * @param value A URI that points to the blob containing the drive manifest file.
     */
    @JvmName("dwavdvnrdlsrxcwi")
    public suspend fun manifestUri(`value`: Output<String>) {
        this.manifestUri = value
    }

    /**
     * @param value Percentage completed for the drive.
     */
    @JvmName("agdvfopvawdlfcim")
    public suspend fun percentComplete(`value`: Output<Double>) {
        this.percentComplete = value
    }

    /**
     * @param value The drive's current state.
     */
    @JvmName("ssgsjiyncxycllmn")
    public suspend fun state(`value`: Output<Either<String, DriveState>>) {
        this.state = value
    }

    /**
     * @param value A URI that points to the blob containing the verbose log for the data transfer operation.
     */
    @JvmName("fptwbghpxyejfbvu")
    public suspend fun verboseLogUri(`value`: Output<String>) {
        this.verboseLogUri = value
    }

    /**
     * @param value The BitLocker key used to encrypt the drive.
     */
    @JvmName("thcxtqmimbrkhgah")
    public suspend fun bitLockerKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitLockerKey = mapped
    }

    /**
     * @param value Bytes successfully transferred for the drive.
     */
    @JvmName("hjwgxwvvssdyjjgb")
    public suspend fun bytesSucceeded(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bytesSucceeded = mapped
    }

    /**
     * @param value Detailed status about the data transfer process. This field is not returned in the response until the drive is in the Transferring state.
     */
    @JvmName("kkbhrgomunmqegdw")
    public suspend fun copyStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyStatus = mapped
    }

    /**
     * @param value The drive header hash value.
     */
    @JvmName("hiucwmibhmfprgpp")
    public suspend fun driveHeaderHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driveHeaderHash = mapped
    }

    /**
     * @param value The drive's hardware serial number, without spaces.
     */
    @JvmName("djdlwrqrvubksklf")
    public suspend fun driveId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driveId = mapped
    }

    /**
     * @param value A URI that points to the blob containing the error log for the data transfer operation.
     */
    @JvmName("tchojxebgcdtspgs")
    public suspend fun errorLogUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorLogUri = mapped
    }

    /**
     * @param value The relative path of the manifest file on the drive.
     */
    @JvmName("cfjokybytrfioprm")
    public suspend fun manifestFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestFile = mapped
    }

    /**
     * @param value The Base16-encoded MD5 hash of the manifest file on the drive.
     */
    @JvmName("aaswukwajqbjkekj")
    public suspend fun manifestHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestHash = mapped
    }

    /**
     * @param value A URI that points to the blob containing the drive manifest file.
     */
    @JvmName("iiuikepvcagjiooc")
    public suspend fun manifestUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestUri = mapped
    }

    /**
     * @param value Percentage completed for the drive.
     */
    @JvmName("mdemcqtrxhbpmhsy")
    public suspend fun percentComplete(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentComplete = mapped
    }

    /**
     * @param value The drive's current state.
     */
    @JvmName("rygdqbnvflnckiqb")
    public suspend fun state(`value`: Either<String, DriveState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The drive's current state.
     */
    @JvmName("rqqpqybeotmjpade")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DriveState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The drive's current state.
     */
    @JvmName("ccyscrdrpobvsghv")
    public fun state(`value`: DriveState) {
        val toBeMapped = Either.ofRight<String, DriveState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value A URI that points to the blob containing the verbose log for the data transfer operation.
     */
    @JvmName("ddtepnfggvngbvgb")
    public suspend fun verboseLogUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verboseLogUri = mapped
    }

    internal fun build(): DriveStatusArgs = DriveStatusArgs(
        bitLockerKey = bitLockerKey,
        bytesSucceeded = bytesSucceeded,
        copyStatus = copyStatus,
        driveHeaderHash = driveHeaderHash,
        driveId = driveId,
        errorLogUri = errorLogUri,
        manifestFile = manifestFile,
        manifestHash = manifestHash,
        manifestUri = manifestUri,
        percentComplete = percentComplete,
        state = state,
        verboseLogUri = verboseLogUri,
    )
}
